"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.Meta = void 0;
var crdt_meta_1 = require("@cicnet/crdt-meta");
var user_1 = require("./user");
var phone_1 = require("./phone");
var custom_1 = require("./custom");
var fetch = require("node-fetch");
var headers = {
    'Content-Type': 'application/json;charset=utf-8',
    'x-cic-automerge': 'client'
};
var options = {
    headers: headers
};
var Meta = /** @class */ (function () {
    function Meta(metaUrl, privateKey) {
        var _this = this;
        this.keystore = new crdt_meta_1.MutablePgpKeyStore();
        this.signer = new crdt_meta_1.PGPSigner(this.keystore);
        this.metaUrl = metaUrl;
        this.privateKey = privateKey;
        this.keystore.loadKeyring().then(function () {
            _this.keystore.importPrivateKey(privateKey).then(function () { return _this.onload(true); });
        });
    }
    Meta.prototype.set = function (identifier, data) {
        return __awaiter(this, void 0, void 0, function () {
            var syncable, response, res, update, prop, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Meta.get(identifier, this.metaUrl)];
                    case 1:
                        response = _a.sent();
                        if (!(response === "Request to " + this.metaUrl + "/" + identifier + " failed. Connection error.")) return [3 /*break*/, 2];
                        return [2 /*return*/, response];
                    case 2:
                        if (!(typeof response !== "object" || typeof data !== "object")) return [3 /*break*/, 4];
                        syncable = new crdt_meta_1.Syncable(identifier, data);
                        return [4 /*yield*/, this.updateMeta(syncable, identifier)];
                    case 3:
                        res = _a.sent();
                        return [2 /*return*/, res.status + ": " + res.statusText];
                    case 4: return [4 /*yield*/, Meta.get(identifier, this.metaUrl)];
                    case 5:
                        syncable = _a.sent();
                        update = [];
                        for (prop in data) {
                            update.push(new crdt_meta_1.ArgPair(prop, data[prop]));
                        }
                        syncable.update(update, 'client-branch');
                        return [4 /*yield*/, this.updateMeta(syncable, identifier)];
                    case 6:
                        res = _a.sent();
                        return [2 /*return*/, res.status + ": " + res.statusText];
                }
            });
        });
    };
    Meta.prototype.updateMeta = function (syncable, identifier) {
        return __awaiter(this, void 0, void 0, function () {
            var envelope, reqBody, putOptions;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.wrap(syncable)];
                    case 1:
                        envelope = _a.sent();
                        reqBody = envelope.toJSON();
                        putOptions = {
                            method: 'PUT',
                            headers: headers,
                            body: reqBody
                        };
                        return [4 /*yield*/, fetch(this.metaUrl + "/" + identifier, putOptions).then(function (response) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    if (response.ok) {
                                        return [2 /*return*/, Promise.resolve({
                                                status: response.status,
                                                statusText: response.statusText + ', Metadata updated successfully!'
                                            })];
                                    }
                                    else {
                                        return [2 /*return*/, Promise.reject({
                                                status: response.status,
                                                statusText: response.statusText
                                            })];
                                    }
                                    return [2 /*return*/];
                                });
                            }); })];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    Meta.get = function (identifier, metaUrl) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, fetch(metaUrl + "/" + identifier, options).then(function (response) {
                            if (response.ok) {
                                return (response.json());
                            }
                            else {
                                return Promise.reject({
                                    status: response.status,
                                    statusText: response.statusText
                                });
                            }
                        })["catch"](function (error) {
                            if (error.code === 'ECONNREFUSED') {
                                return "Request to " + metaUrl + "/" + identifier + " failed. Connection error.";
                            }
                            return error.status + ": " + error.statusText;
                        })];
                    case 1:
                        response = _a.sent();
                        if (typeof response !== "object") {
                            return [2 /*return*/, response];
                        }
                        return [2 /*return*/, crdt_meta_1.Envelope.fromJSON(JSON.stringify(response)).unwrap()];
                }
            });
        });
    };
    Meta.getIdentifier = function (name, type) {
        if (type === void 0) { type = 'custom'; }
        return __awaiter(this, void 0, void 0, function () {
            var identifier;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        type = type.toLowerCase();
                        if (!(type === 'user')) return [3 /*break*/, 2];
                        return [4 /*yield*/, user_1.User.toKey(name)];
                    case 1:
                        identifier = _a.sent();
                        return [3 /*break*/, 6];
                    case 2:
                        if (!(type === 'phone')) return [3 /*break*/, 4];
                        return [4 /*yield*/, phone_1.Phone.toKey(name)];
                    case 3:
                        identifier = _a.sent();
                        return [3 /*break*/, 6];
                    case 4: return [4 /*yield*/, custom_1.Custom.toKey(name)];
                    case 5:
                        identifier = _a.sent();
                        _a.label = 6;
                    case 6: return [2 /*return*/, identifier];
                }
            });
        });
    };
    Meta.prototype.wrap = function (syncable) {
        var _this = this;
        return new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                syncable.setSigner(this.signer);
                syncable.onwrap = function (env) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        if (env === undefined) {
                            reject();
                            return [2 /*return*/];
                        }
                        resolve(env);
                        return [2 /*return*/];
                    });
                }); };
                syncable.sign();
                return [2 /*return*/];
            });
        }); });
    };
    return Meta;
}());
exports.Meta = Meta;
