"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addressToBytes = exports.bytesToHex = exports.mergeKey = exports.toAddressKey = exports.toKey = void 0;
const crypto = __importStar(require("./crypto"));
function stringToBytes(s) {
    const a = new Uint8Array(20);
    let j = 2;
    for (let i = 0; i < a.byteLength; i++) {
        const n = parseInt(s.substring(j, j + 2), 16);
        a[i] = n;
        j += 2;
    }
    return a;
}
function bytesToHex(a) {
    let s = '';
    for (let i = 0; i < a.byteLength; i++) {
        const h = '00' + a[i].toString(16);
        s += h.slice(-2);
    }
    return s;
}
exports.bytesToHex = bytesToHex;
function mergeKey(a, s) {
    return __awaiter(this, void 0, void 0, function* () {
        const y = new Uint8Array(a.byteLength + s.byteLength);
        for (let i = 0; i < a.byteLength; i++) {
            y[i] = a[i];
        }
        for (let i = 0; i < s.byteLength; i++) {
            y[a.byteLength + i] = s[i];
        }
        const z = yield crypto.subtle.digest('SHA-256', y);
        return bytesToHex(new Uint8Array(z));
    });
}
exports.mergeKey = mergeKey;
function toKey(v, salt) {
    return __awaiter(this, void 0, void 0, function* () {
        const a = stringToBytes(v);
        const s = new TextEncoder().encode(salt);
        return yield mergeKey(a, s);
    });
}
exports.toKey = toKey;
function toAddressKey(zeroExHex, salt) {
    return __awaiter(this, void 0, void 0, function* () {
        const a = addressToBytes(zeroExHex);
        const s = new TextEncoder().encode(salt);
        return yield mergeKey(a, s);
    });
}
exports.toAddressKey = toAddressKey;
const re_addrHex = /^0[xX][a-fA-F0-9]{40}$/;
function addressToBytes(s) {
    if (!s.match(re_addrHex)) {
        throw 'invalid address hex';
    }
    return stringToBytes(s);
}
exports.addressToBytes = addressToBytes;
//# sourceMappingURL=digest.js.map