"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromIndexKey = exports.toIndexKey = exports.Dispatcher = void 0;
const uuid_1 = require("uuid");
function toIndexKey(id) {
    const d = Date.now();
    return d + '_' + id + '_' + uuid_1.v4();
}
exports.toIndexKey = toIndexKey;
const _re_indexKey = /^\d+_(.+)_[-\d\w]+$/;
function fromIndexKey(s) {
    const m = s.match(_re_indexKey);
    if (m === null) {
        throw 'Invalid index key';
    }
    return m[1];
}
exports.fromIndexKey = fromIndexKey;
class Dispatcher {
    constructor(store, syncer) {
        this.idx = new Array();
        this.syncer = syncer;
        this.store = store;
    }
    isDirty() {
        return this.idx.length > 0;
    }
    add(id, item) {
        const v = item.toJSON();
        const k = toIndexKey(id);
        this.store.put(k, v, true);
        localStorage.setItem(k, v);
        this.idx.push(k);
        return k;
    }
    sync(offset) {
        let i = 0;
        this.idx.forEach((k) => {
            const v = localStorage.getItem(k);
            const k_id = fromIndexKey(k);
            this.syncer.pub(v); // this must block until guaranteed delivery
            localStorage.removeItem(k);
            i++;
        });
        return i;
    }
}
exports.Dispatcher = Dispatcher;
//# sourceMappingURL=dispatch.js.map