import { JSONSerializable } from './format';
import { Authoritative, Signer, Signable } from './auth';
import { VersionedSpec } from './constants';
declare class Envelope {
    o: VersionedSpec;
    constructor(payload: Object);
    set(payload: Object): void;
    get(): string;
    toJSON(): string;
    static fromJSON(s: string): Envelope;
    unwrap(): Syncable;
}
declare class ArgPair {
    k: string;
    v: any;
    constructor(k: string, v: any);
}
declare class Syncable implements JSONSerializable, Authoritative, Signable {
    id: string;
    timestamp: number;
    m: any;
    e: Envelope;
    signer: Signer;
    onwrap: (string: any) => void;
    onauthenticate: (boolean: any) => void;
    constructor(id: string, v: Object);
    setSigner(signer: Signer): void;
    digest(): string;
    private wrap;
    authenticate(full?: boolean): void;
    sign(): void;
    update(changes: Array<ArgPair>, changesDescription: string): void;
    replace(o: Object, changesDescription: string): void;
    merge(s: Syncable): void;
    toJSON(): string;
    static fromJSON(s: string): Syncable;
}
export { JSONSerializable, Syncable, ArgPair, Envelope };
