declare type DbConfig = {
    name: string;
    host: string;
    port: number;
    user: string;
    password: string;
};
interface DbAdapter {
    query: (s: string, callback: (e: any, rs: any) => void) => void;
    close: () => void;
}
declare class SqliteAdapter implements DbAdapter {
    db: any;
    constructor(dbConfig: DbConfig, callback?: (any: any) => void);
    query(s: string, callback: (e: any, rs?: any) => void): void;
    close(): void;
}
declare class PostgresAdapter implements DbAdapter {
    db: any;
    constructor(dbConfig: DbConfig);
    query(s: string, callback: (e: any, rs: any) => void): void;
    close(): void;
}
export { DbConfig, SqliteAdapter, PostgresAdapter, };
