import * as pg from 'pg';
import * as sqlite from 'sqlite3';
const re_creatematch = /^(CREATE)/i;
const re_getmatch = /^(SELECT)/i;
const re_setmatch = /^(INSERT|UPDATE)/i;
class SqliteAdapter {
    constructor(dbConfig, callback) {
        this.db = new sqlite.Database(dbConfig.name); //, callback);
    }
    query(s, callback) {
        const local_callback = (e, rs) => {
            let r = undefined;
            if (rs !== undefined) {
                r = {
                    rowCount: rs.length,
                    rows: rs,
                };
            }
            callback(e, r);
        };
        if (s.match(re_getmatch)) {
            this.db.all(s, local_callback);
        }
        else if (s.match(re_setmatch)) {
            this.db.run(s, local_callback);
        }
        else if (s.match(re_creatematch)) {
            this.db.run(s, callback);
        }
        else {
            throw 'unhandled query';
        }
    }
    close() {
        this.db.close();
    }
}
class PostgresAdapter {
    constructor(dbConfig) {
        let o = dbConfig;
        o['database'] = o.name;
        this.db = new pg.Pool(o);
        return this.db;
    }
    query(s, callback) {
        this.db.query(s, (e, rs) => {
            let r = {
                length: rs.rowCount,
            };
            rs.length = rs.rowCount;
            if (e === undefined) {
                e = null;
            }
            console.debug(e, rs);
            callback(e, rs);
        });
    }
    close() {
        this.db.end();
    }
}
export { SqliteAdapter, PostgresAdapter, };
//# sourceMappingURL=db.js.map