import * as Automerge from 'automerge';
import { engineSpec, cryptoSpec } from './constants';
const fullSpec = {
    name: 'cic',
    version: '1',
    ext: {
        network: cryptoSpec,
        engine: engineSpec,
    },
};
class Envelope {
    constructor(payload) {
        this.o = fullSpec;
        this.set(payload);
    }
    set(payload) {
        this.o['payload'] = payload;
    }
    get() {
        return this.o['payload'];
    }
    toJSON() {
        return JSON.stringify(this.o);
    }
    static fromJSON(s) {
        const e = new Envelope(undefined);
        e.o = JSON.parse(s);
        return e;
    }
    unwrap() {
        return Syncable.fromJSON(this.o['payload']);
    }
}
class ArgPair {
    constructor(k, v) {
        this.k = k;
        this.v = v;
    }
}
class SignablePart {
    constructor(s) {
        this.s = s;
    }
    digest() {
        return this.s;
    }
}
function orderDict(src) {
    let dst;
    if (Array.isArray(src)) {
        dst = [];
        src.forEach((v) => {
            if (typeof (v) == 'object') {
                v = orderDict(v);
            }
            dst.push(v);
        });
    }
    else {
        dst = {};
        Object.keys(src).sort().forEach((k) => {
            let v = src[k];
            if (typeof (v) == 'object') {
                v = orderDict(v);
            }
            dst[k] = v;
        });
    }
    return dst;
}
class Syncable {
    // TODO: Move data to sub-object so timestamp, id, signature don't collide
    constructor(id, v) {
        this.id = id;
        const o = {
            'id': id,
            'timestamp': Math.floor(Date.now() / 1000),
            'data': v,
        };
        //this.m = Automerge.from(v)
        this.m = Automerge.from(o);
    }
    setSigner(signer) {
        this.signer = signer;
        this.signer.onsign = (s) => {
            this.wrap(s);
        };
    }
    // TODO: To keep integrity, the non-link key/value pairs for each step also need to be hashed
    digest() {
        const links = [];
        Automerge.getAllChanges(this.m).forEach((ch) => {
            const op = ch['ops'];
            ch['ops'].forEach((op) => {
                if (op['action'] == 'link') {
                    //console.log('op link', op);
                    links.push([op['obj'], op['value']]);
                }
            });
        });
        //return JSON.stringify(links);
        const j = JSON.stringify(links);
        return Buffer.from(j).toString('base64');
    }
    wrap(s) {
        this.m = Automerge.change(this.m, 'sign', (doc) => {
            doc['signature'] = s;
        });
        this.e = new Envelope(this.toJSON());
        // console.log('wrappin s', s, typeof(s));
        this.e.o['digest'] = s.digest;
        if (this.onwrap !== undefined) {
            this.onwrap(this.e);
        }
    }
    //	private _verifyLoop(i:number, history:Array<any>, signable:Signable, result:boolean) {
    //		if (!result) {
    //			this.onauthenticate(false);
    //			return;
    //		} else if (history.length == 0) {
    //			this.onauthenticate(true);
    //			return;
    //		}
    //		const h = history.shift()
    //		if (i % 2 == 0) {
    //			i++;
    //			signable = {
    //				digest: () => {
    //					return Automerge.save(h.snapshot)
    //				},
    //			};
    //			this._verifyLoop(i, history, signable, true);
    //		} else {
    //			i++;
    //			const signature = h.snapshot['signature'];
    //			console.debug('signature', signature, signable.digest());
    //			this.signer.onverify = (v) => {
    //				this._verifyLoop(i, history, signable, v)
    //			}
    //			this.signer.verify(signable, signature);
    //		}
    //	}
    //
    //	// TODO: This should replay the graph and check signatures on each step
    //	public _authenticate(full:boolean=false) {
    //		let h = Automerge.getHistory(this.m);
    //		h.forEach((m) => {
    //			//console.debug(m.snapshot);
    //		});
    //		const signable = {
    //			digest: () => { return '' },
    //		}
    //		if (!full) {
    //			h = h.slice(h.length-2);
    //		}
    //		this._verifyLoop(0, h, signable, true);
    //	}
    authenticate(full = false) {
        if (full) {
            console.warn('only doing shallow authentication for now, sorry');
        }
        //console.log('authenticating', signable.digest());
        //console.log('signature', this.m.signature);
        this.signer.onverify = (v) => {
            //this._verifyLoop(i, history, signable, v)
            this.onauthenticate(v);
        };
        this.signer.verify(this.m.signature.digest, this.m.signature);
    }
    sign() {
        //this.signer.prepare(this);
        this.signer.sign(this.digest());
    }
    update(changes, changesDescription) {
        this.m = Automerge.change(this.m, changesDescription, (m) => {
            changes.forEach((c) => {
                let path = c.k.split('.');
                let target = m['data'];
                while (path.length > 1) {
                    const part = path.shift();
                    target = target[part];
                }
                target[path[0]] = c.v;
            });
            m['timestamp'] = Math.floor(Date.now() / 1000);
        });
    }
    replace(o, changesDescription) {
        this.m = Automerge.change(this.m, changesDescription, (m) => {
            Object.keys(o).forEach((k) => {
                m['data'][k] = o[k];
            });
            Object.keys(m).forEach((k) => {
                if (o[k] == undefined) {
                    delete m['data'][k];
                }
            });
            m['timestamp'] = Math.floor(Date.now() / 1000);
        });
    }
    merge(s) {
        this.m = Automerge.merge(s.m, this.m);
    }
    toJSON() {
        const s = Automerge.save(this.m);
        const o = JSON.parse(s);
        const oo = orderDict(o);
        return JSON.stringify(oo);
    }
    static fromJSON(s) {
        const doc = Automerge.load(s);
        let y = new Syncable(doc['id'], {});
        y.m = doc;
        return y;
    }
}
export { Syncable, ArgPair, Envelope };
//# sourceMappingURL=sync.js.map