interface Signable {
    digest(): string;
}
declare type KeyGetter = () => any;
declare type Signature = {
    engine: string;
    algo: string;
    data: string;
    digest: string;
};
interface Signer {
    prepare(Signable: any): boolean;
    onsign(Signature: any): void;
    onverify(boolean: any): void;
    sign(digest: string): void;
    verify(digest: string, signature: Signature): void;
    fingerprint(): string;
}
interface Authoritative {
}
interface KeyStore {
    getPrivateKey: KeyGetter;
    getFingerprint: () => string;
    getTrustedKeys: () => Array<any>;
    getTrustedActiveKeys: () => Array<any>;
    getEncryptKeys: () => Array<any>;
}
declare class PGPKeyStore implements KeyStore {
    fingerprint: string;
    pk: any;
    pubk: {
        active: any[];
        trusted: any[];
        encrypt: any[];
    };
    loads: number;
    loadsTarget: number;
    onload: (k: KeyStore) => void;
    constructor(passphrase: string, pkArmor: string, pubkActiveArmor: string, pubkTrustedArmor: string, pubkEncryptArmor: string, onload?: (ks: KeyStore) => void);
    private _readKey;
    private _registerLoad;
    getTrustedKeys(): Array<any>;
    getTrustedActiveKeys(): Array<any>;
    getEncryptKeys(): Array<any>;
    getPrivateKey(): any;
    getFingerprint(): string;
}
declare class PGPSigner implements Signer {
    engine: string;
    algo: string;
    dgst: string;
    signature: Signature;
    keyStore: KeyStore;
    onsign: (Signature: any) => void;
    onverify: (boolean: any) => void;
    constructor(keyStore: KeyStore);
    fingerprint(): string;
    prepare(material: Signable): boolean;
    verify(digest: string, signature: Signature): void;
    sign(digest: string): void;
}
export { Signature, Authoritative, Signer, KeyGetter, Signable, KeyStore, PGPSigner, PGPKeyStore, };
