"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = void 0;
const fs = __importStar(require("fs"));
const ini = __importStar(require("ini"));
const path = __importStar(require("path"));
class Config {
    constructor(filepath, env_prefix) {
        this.filepath = filepath;
        this.store = {};
        this.censor = [];
        this.require = [];
        this.env_prefix = '';
        if (env_prefix !== undefined) {
            this.env_prefix = env_prefix + "_";
        }
    }
    process() {
        const d = fs.readdirSync(this.filepath);
        const r = /.*\.ini$/;
        for (let i = 0; i < d.length; i++) {
            const f = d[i];
            if (!f.match(r)) {
                return;
            }
            const fp = path.join(this.filepath, f);
            const v = fs.readFileSync(fp, 'utf-8');
            const inid = ini.decode(v);
            const inik = Object.keys(inid);
            for (let j = 0; j < inik.length; j++) {
                const k_section = inik[j];
                const k = k_section.toUpperCase();
                Object.keys(inid[k_section]).forEach((k_directive) => {
                    const kk = k_directive.toUpperCase();
                    const kkk = k + '_' + kk;
                    let r = inid[k_section][k_directive];
                    const k_env = this.env_prefix + kkk;
                    const env = process.env[k_env];
                    if (env !== undefined) {
                        console.debug('Environment variable ' + k_env + ' overrides ' + kkk);
                        r = env;
                    }
                    this.store[kkk] = r;
                });
            }
        }
    }
    get(s) {
        return this.store[s];
    }
    toString() {
        let s = '';
        Object.keys(this.store).forEach((k) => {
            s += k + '=' + this.store[k] + '\n';
        });
        return s;
    }
}
exports.Config = Config;
//# sourceMappingURL=config.js.map