"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostgresAdapter = exports.SqliteAdapter = void 0;
const pg = __importStar(require("pg"));
const sqlite = __importStar(require("sqlite3"));
const re_creatematch = /^(CREATE)/i;
const re_getmatch = /^(SELECT)/i;
const re_setmatch = /^(INSERT|UPDATE)/i;
class SqliteAdapter {
    constructor(dbConfig, callback) {
        this.db = new sqlite.Database(dbConfig.name); //, callback);
    }
    query(s, callback) {
        const local_callback = (e, rs) => {
            let r = undefined;
            if (rs !== undefined) {
                r = {
                    rowCount: rs.length,
                    rows: rs,
                };
            }
            callback(e, r);
        };
        if (s.match(re_getmatch)) {
            this.db.all(s, local_callback);
        }
        else if (s.match(re_setmatch)) {
            this.db.run(s, local_callback);
        }
        else if (s.match(re_creatematch)) {
            this.db.run(s, callback);
        }
        else {
            throw 'unhandled query';
        }
    }
    close() {
        this.db.close();
    }
}
exports.SqliteAdapter = SqliteAdapter;
class PostgresAdapter {
    constructor(dbConfig) {
        let o = dbConfig;
        o['database'] = o.name;
        this.db = new pg.Pool(o);
        return this.db;
    }
    query(s, callback) {
        this.db.query(s, (e, rs) => {
            let r = {
                length: rs.rowCount,
            };
            rs.length = rs.rowCount;
            if (e === undefined) {
                e = null;
            }
            console.debug(e, rs);
            callback(e, rs);
        });
    }
    close() {
        this.db.end();
    }
}
exports.PostgresAdapter = PostgresAdapter;
//# sourceMappingURL=db.js.map