import { KeyStore } from './auth';
interface MutableKeyStore extends KeyStore {
    loadKeyring(): void;
    importKeyPair(publicKey: any, privateKey: any): Promise<void>;
    importPublicKey(publicKey: any): void;
    importPrivateKey(privateKey: any): Promise<void>;
    getPublicKeys(): Array<any>;
    getTrustedKeys(): Array<any>;
    getTrustedActiveKeys(): Array<any>;
    getEncryptKeys(): Array<any>;
    getPrivateKeys(): Array<any>;
    getPrivateKey(): any;
    isValidKey(key: any): Promise<boolean>;
    isEncryptedPrivateKey(privateKey: any): Promise<boolean>;
    getFingerprint(): string;
    getKeyId(key: any): string;
    getPrivateKeyId(): string;
    getKeysForId(keyId: string): Array<any>;
    getPublicKeyForId(keyId: string): any;
    getPrivateKeyForId(keyId: string): any;
    getPublicKeyForSubkeyId(subkeyId: string): any;
    getPublicKeysForAddress(address: string): Array<any>;
    removeKeysForId(keyId: string): Array<any>;
    removePublicKeyForId(keyId: string): any;
    removePublicKey(publicKey: any): any;
    clearKeysInKeyring(): void;
    sign(plainText: string): Promise<any>;
}
declare class MutablePgpKeyStore implements MutableKeyStore {
    loadKeyring(): Promise<void>;
    importKeyPair(publicKey: any, privateKey: any): Promise<void>;
    importPublicKey(publicKey: any): void;
    importPrivateKey(privateKey: any): Promise<void>;
    getPublicKeys(): Array<any>;
    getTrustedKeys(): Array<any>;
    getTrustedActiveKeys(): Array<any>;
    getEncryptKeys(): Array<any>;
    getPrivateKeys(): Array<any>;
    getPrivateKey(): any;
    isValidKey(key: any): Promise<boolean>;
    isEncryptedPrivateKey(privateKey: any): Promise<boolean>;
    getFingerprint(): string;
    getKeyId(key: any): string;
    getPrivateKeyId(): string;
    getKeysForId(keyId: string): Array<any>;
    getPublicKeyForId(keyId: any): any;
    getPrivateKeyForId(keyId: any): any;
    getPublicKeyForSubkeyId(subkeyId: any): any;
    getPublicKeysForAddress(address: any): Array<any>;
    removeKeysForId(keyId: any): Array<any>;
    removePublicKeyForId(keyId: any): any;
    removePublicKey(publicKey: any): any;
    clearKeysInKeyring(): void;
    sign(plainText: any): Promise<any>;
}
export { MutablePgpKeyStore, MutableKeyStore };
