"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutablePgpKeyStore = void 0;
// TODO should we put this on the mutable key store object
const openpgp = __importStar(require("openpgp"));
const keyring = new openpgp.Keyring();
class MutablePgpKeyStore {
    loadKeyring() {
        return __awaiter(this, void 0, void 0, function* () {
            yield keyring.load();
            yield keyring.store();
        });
    }
    importKeyPair(publicKey, privateKey) {
        return __awaiter(this, void 0, void 0, function* () {
            yield keyring.publicKeys.importKey(publicKey);
            yield keyring.privateKeys.importKey(privateKey);
        });
    }
    importPublicKey(publicKey) {
        keyring.publicKeys.importKey(publicKey);
    }
    importPrivateKey(privateKey) {
        return __awaiter(this, void 0, void 0, function* () {
            yield keyring.privateKeys.importKey(privateKey);
        });
    }
    getPublicKeys() {
        return keyring.publicKeys.keys;
    }
    getTrustedKeys() {
        return keyring.publicKeys.keys;
    }
    getTrustedActiveKeys() {
        return keyring.publicKeys.keys;
    }
    getEncryptKeys() {
        return [];
    }
    getPrivateKeys() {
        return keyring.privateKeys.keys;
    }
    getPrivateKey() {
        return keyring.privateKeys && keyring.privateKeys.keys[0];
    }
    isValidKey(key) {
        return __awaiter(this, void 0, void 0, function* () {
            // There is supposed to be an openpgp.readKey() method but I can't find it?
            const _key = yield openpgp.key.readArmored(key);
            return !_key.err;
        });
    }
    isEncryptedPrivateKey(privateKey) {
        return __awaiter(this, void 0, void 0, function* () {
            const imported = yield openpgp.key.readArmored(privateKey);
            for (const key of imported.keys) {
                if (key.isDecrypted()) {
                    return false;
                }
            }
            return true;
        });
    }
    getFingerprint() {
        // TODO Handle multiple keys
        return keyring.privateKeys && keyring.privateKeys.keys[0] && keyring.privateKeys.keys[0].keyPacket &&
            keyring.privateKeys.keys[0].keyPacket.fingerprint;
    }
    getKeyId(key) {
        return key.getKeyId().toHex();
    }
    getPrivateKeyId() {
        // TODO is there a library that comes with angular for doing this?
        return keyring.privateKeys && keyring.privateKeys.keys[0] && keyring.privateKeys.keys[0].getKeyId().toHex();
    }
    getKeysForId(keyId) {
        return keyring.getKeysForId(keyId);
    }
    getPublicKeyForId(keyId) {
        return keyring.publicKeys.getForId(keyId);
    }
    getPrivateKeyForId(keyId) {
        return keyring.privateKeys.getForId(keyId);
    }
    getPublicKeyForSubkeyId(subkeyId) {
        return keyring.publicKeys.getForId(subkeyId, true);
    }
    getPublicKeysForAddress(address) {
        return keyring.publicKeys.getForAddress(address);
    }
    removeKeysForId(keyId) {
        return keyring.removeKeysForId(keyId);
    }
    removePublicKeyForId(keyId) {
        return keyring.publicKeys.removeForId(keyId);
    }
    removePublicKey(publicKey) {
        const keyId = publicKey.getKeyId().toHex();
        return keyring.publicKeys.removeForId(keyId);
    }
    clearKeysInKeyring() {
        keyring.clear();
    }
    sign(plainText) {
        return __awaiter(this, void 0, void 0, function* () {
            const privateKey = this.getPrivateKey();
            if (!privateKey.isDecrypted()) {
                const password = window.prompt('password');
                yield privateKey.decrypt(password);
            }
            const opts = {
                message: openpgp.message.fromText(plainText),
                privateKeys: [privateKey],
                detached: true,
            };
            const signatureObject = yield openpgp.sign(opts);
            return signatureObject.signature;
        });
    }
}
exports.MutablePgpKeyStore = MutablePgpKeyStore;
//# sourceMappingURL=keyring.js.map