"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _propUtils = require("./utils/prop-utils");

var AggregationLayer = function (_CompositeLayer) {
  (0, _inherits2["default"])(AggregationLayer, _CompositeLayer);

  function AggregationLayer() {
    (0, _classCallCheck2["default"])(this, AggregationLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(AggregationLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(AggregationLayer, [{
    key: "initializeState",
    value: function initializeState(dimensions) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(AggregationLayer.prototype), "initializeState", this).call(this);
      this.setState({
        ignoreProps: (0, _propUtils.filterProps)(this.constructor._propTypes, dimensions.data.props),
        dimensions: dimensions
      });
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(AggregationLayer.prototype), "updateState", this).call(this, opts);
      var changeFlags = opts.changeFlags;

      if (changeFlags.extensionsChanged) {
        var shaders = this.getShaders({});

        if (shaders && shaders.defines) {
          shaders.defines.NON_INSTANCED_MODEL = 1;
        }

        this.updateShaders(shaders);
      }

      this._updateAttributes(opts.props);
    }
  }, {
    key: "updateAttributes",
    value: function updateAttributes(changedAttributes) {
      this.setState({
        changedAttributes: changedAttributes
      });
    }
  }, {
    key: "getAttributes",
    value: function getAttributes() {
      return this.getAttributeManager().getShaderAttributes();
    }
  }, {
    key: "getModuleSettings",
    value: function getModuleSettings() {
      var _this$context = this.context,
          viewport = _this$context.viewport,
          mousePosition = _this$context.mousePosition,
          gl = _this$context.gl;
      var moduleSettings = Object.assign(Object.create(this.props), {
        viewport: viewport,
        mousePosition: mousePosition,
        pickingActive: 0,
        devicePixelRatio: (0, _core2.cssToDeviceRatio)(gl)
      });
      return moduleSettings;
    }
  }, {
    key: "updateShaders",
    value: function updateShaders(shaders) {}
  }, {
    key: "isAggregationDirty",
    value: function isAggregationDirty(updateOpts) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var props = updateOpts.props,
          oldProps = updateOpts.oldProps,
          changeFlags = updateOpts.changeFlags;
      var _params$compareAll = params.compareAll,
          compareAll = _params$compareAll === void 0 ? false : _params$compareAll,
          dimension = params.dimension;
      var ignoreProps = this.state.ignoreProps;
      var dataProps = dimension.props,
          _dimension$accessors = dimension.accessors,
          accessors = _dimension$accessors === void 0 ? [] : _dimension$accessors;
      var updateTriggersChanged = changeFlags.updateTriggersChanged;

      if (updateTriggersChanged) {
        if (updateTriggersChanged.all) {
          return true;
        }

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = accessors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var accessor = _step.value;

            if (updateTriggersChanged[accessor]) {
              return true;
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }

      if (compareAll) {
        if (changeFlags.extensionsChanged) {
          return true;
        }

        return (0, _core._compareProps)({
          oldProps: oldProps,
          newProps: props,
          ignoreProps: ignoreProps,
          propTypes: this.constructor._propTypes
        });
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = dataProps[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var name = _step2.value;

          if (props[name] !== oldProps[name]) {
            return true;
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return false;
    }
  }, {
    key: "isAttributeChanged",
    value: function isAttributeChanged(name) {
      var changedAttributes = this.state.changedAttributes;

      if (!name) {
        return !isObjectEmpty(changedAttributes);
      }

      return changedAttributes && changedAttributes[name] !== undefined;
    }
  }, {
    key: "_getAttributeManager",
    value: function _getAttributeManager() {
      return new _core.AttributeManager(this.context.gl, {
        id: this.props.id,
        stats: this.context.stats
      });
    }
  }]);
  return AggregationLayer;
}(_core.CompositeLayer);

exports["default"] = AggregationLayer;

function isObjectEmpty(obj) {
  var isEmpty = true;

  for (var key in obj) {
    isEmpty = false;
    break;
  }

  return isEmpty;
}

AggregationLayer.layerName = 'AggregationLayer';
//# sourceMappingURL=aggregation-layer.js.map