"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _heatmapLayerUtils = require("./heatmap-layer-utils");

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _triangleLayer = _interopRequireDefault(require("./triangle-layer"));

var _aggregationLayer = _interopRequireDefault(require("../aggregation-layer"));

var _colorUtils = require("../utils/color-utils");

var _weightsVs = _interopRequireDefault(require("./weights-vs.glsl"));

var _weightsFs = _interopRequireDefault(require("./weights-fs.glsl"));

var _maxVs = _interopRequireDefault(require("./max-vs.glsl"));

var _parameters;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var RESOLUTION = 2;
var SIZE_2K = 2048;
var ZOOM_DEBOUNCE = 500;
var TEXTURE_OPTIONS = {
  mipmaps: false,
  parameters: (_parameters = {}, (0, _defineProperty2["default"])(_parameters, 10240, 9729), (0, _defineProperty2["default"])(_parameters, 10241, 9729), (0, _defineProperty2["default"])(_parameters, 10242, 33071), (0, _defineProperty2["default"])(_parameters, 10243, 33071), _parameters),
  dataFormat: 6408
};
var DEFAULT_COLOR_DOMAIN = [0, 0];
var defaultProps = {
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getWeight: {
    type: 'accessor',
    value: 1
  },
  intensity: {
    type: 'number',
    min: 0,
    value: 1
  },
  radiusPixels: {
    type: 'number',
    min: 1,
    max: 100,
    value: 50
  },
  colorRange: _colorUtils.defaultColorRange,
  threshold: {
    type: 'number',
    min: 0,
    max: 1,
    value: 0.05
  },
  colorDomain: {
    type: 'array',
    value: null,
    optional: true
  }
};
var REQUIRED_FEATURES = [_core.FEATURES.BLEND_EQUATION_MINMAX, _core.FEATURES.TEXTURE_FLOAT];
var DIMENSIONS = {
  data: {
    props: ['radiusPixels']
  }
};

var HeatmapLayer = function (_AggregationLayer) {
  (0, _inherits2["default"])(HeatmapLayer, _AggregationLayer);

  function HeatmapLayer() {
    (0, _classCallCheck2["default"])(this, HeatmapLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(HeatmapLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(HeatmapLayer, [{
    key: "initializeState",
    value: function initializeState() {
      var gl = this.context.gl;

      if (!(0, _core.hasFeatures)(gl, REQUIRED_FEATURES)) {
        this.setState({
          supported: false
        });

        _core2.log.error("HeatmapLayer: ".concat(this.id, " is not supported on this browser"))();

        return;
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(HeatmapLayer.prototype), "initializeState", this).call(this, DIMENSIONS);
      this.setState({
        supported: true
      });

      this._setupTextureParams();

      this._setupAttributes();

      this._setupResources();
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      if (!this.state.supported) {
        return;
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(HeatmapLayer.prototype), "updateState", this).call(this, opts);
      var props = opts.props,
          oldProps = opts.oldProps;

      var changeFlags = this._getChangeFlags(opts);

      if (changeFlags.viewportChanged) {
        changeFlags.boundsChanged = this._updateBounds();
      }

      if (changeFlags.dataChanged || changeFlags.boundsChanged) {
        this._updateWeightmap();
      } else if (changeFlags.viewportZoomChanged) {
        this._debouncedUpdateWeightmap();
      }

      if (props.colorRange !== oldProps.colorRange) {
        this._updateColorTexture(opts);
      }

      if (changeFlags.viewportChanged) {
        this._updateTextureRenderingBounds();
      }

      if (oldProps.colorDomain !== props.colorDomain || changeFlags.viewportChanged) {
        var viewport = this.context.viewport;
        var weightsScale = this.state.weightsScale;
        var domainScale = (viewport ? 1024 / viewport.scale : 1) * weightsScale;
        var colorDomain = props.colorDomain ? props.colorDomain.map(function (x) {
          return x * domainScale;
        }) : DEFAULT_COLOR_DOMAIN;

        if (colorDomain[1] > 0 && weightsScale < 1) {
          var max = Math.min(colorDomain[1], 1);
          colorDomain[0] *= max / colorDomain[1];
          colorDomain[1] = max;
        }

        this.setState({
          colorDomain: colorDomain
        });
      }

      this.setState({
        zoom: opts.context.viewport.zoom
      });
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      if (!this.state.supported) {
        return [];
      }

      var _this$state = this.state,
          weightsTexture = _this$state.weightsTexture,
          triPositionBuffer = _this$state.triPositionBuffer,
          triTexCoordBuffer = _this$state.triTexCoordBuffer,
          maxWeightsTexture = _this$state.maxWeightsTexture,
          colorTexture = _this$state.colorTexture,
          colorDomain = _this$state.colorDomain;
      var _this$props = this.props,
          updateTriggers = _this$props.updateTriggers,
          intensity = _this$props.intensity,
          threshold = _this$props.threshold;
      var TriangleLayerClass = this.getSubLayerClass('triangle', _triangleLayer["default"]);
      return new TriangleLayerClass(this.getSubLayerProps({
        id: 'triangle-layer',
        updateTriggers: updateTriggers
      }), {
        data: {
          attributes: {
            positions: triPositionBuffer,
            texCoords: triTexCoordBuffer
          }
        },
        vertexCount: 4,
        maxTexture: maxWeightsTexture,
        colorTexture: colorTexture,
        texture: weightsTexture,
        intensity: intensity,
        threshold: threshold,
        colorDomain: colorDomain
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(HeatmapLayer.prototype), "finalizeState", this).call(this);
      var _this$state2 = this.state,
          weightsTransform = _this$state2.weightsTransform,
          weightsTexture = _this$state2.weightsTexture,
          maxWeightTransform = _this$state2.maxWeightTransform,
          maxWeightsTexture = _this$state2.maxWeightsTexture,
          triPositionBuffer = _this$state2.triPositionBuffer,
          triTexCoordBuffer = _this$state2.triTexCoordBuffer,
          colorTexture = _this$state2.colorTexture,
          updateTimer = _this$state2.updateTimer;
      weightsTransform && weightsTransform["delete"]();
      weightsTexture && weightsTexture["delete"]();
      maxWeightTransform && maxWeightTransform["delete"]();
      maxWeightsTexture && maxWeightsTexture["delete"]();
      triPositionBuffer && triPositionBuffer["delete"]();
      triTexCoordBuffer && triTexCoordBuffer["delete"]();
      colorTexture && colorTexture["delete"]();
      updateTimer && clearTimeout(updateTimer);
    }
  }, {
    key: "_getAttributeManager",
    value: function _getAttributeManager() {
      return new _core2.AttributeManager(this.context.gl, {
        id: this.props.id,
        stats: this.context.stats
      });
    }
  }, {
    key: "_getChangeFlags",
    value: function _getChangeFlags(opts) {
      var changeFlags = {};
      var dimensions = this.state.dimensions;
      changeFlags.dataChanged = this.isAttributeChanged() || this.isAggregationDirty(opts, {
        compareAll: true,
        dimension: dimensions.data
      });
      changeFlags.viewportChanged = opts.changeFlags.viewportChanged;
      var zoom = this.state.zoom;

      if (!opts.context.viewport || opts.context.viewport.zoom !== zoom) {
        changeFlags.viewportZoomChanged = true;
      }

      return changeFlags;
    }
  }, {
    key: "_createTextures",
    value: function _createTextures() {
      var gl = this.context.gl;
      var _this$state3 = this.state,
          textureSize = _this$state3.textureSize,
          format = _this$state3.format,
          type = _this$state3.type;
      this.setState({
        weightsTexture: new _core.Texture2D(gl, _objectSpread({
          width: textureSize,
          height: textureSize,
          format: format,
          type: type
        }, TEXTURE_OPTIONS)),
        maxWeightsTexture: new _core.Texture2D(gl, _objectSpread({
          format: format,
          type: type
        }, TEXTURE_OPTIONS))
      });
    }
  }, {
    key: "_setupAttributes",
    value: function _setupAttributes() {
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          accessor: 'getPosition'
        },
        weights: {
          size: 1,
          accessor: 'getWeight'
        }
      });
      this.setState({
        positionAttributeName: 'positions'
      });
    }
  }, {
    key: "_setupTextureParams",
    value: function _setupTextureParams() {
      var gl = this.context.gl;
      var textureSize = Math.min(SIZE_2K, (0, _core.getParameters)(gl, 3379));
      var floatTargetSupport = (0, _core.hasFeatures)(gl, _core.FEATURES.COLOR_ATTACHMENT_RGBA32F);

      var _getTextureParams = (0, _heatmapLayerUtils.getTextureParams)({
        gl: gl,
        floatTargetSupport: floatTargetSupport
      }),
          format = _getTextureParams.format,
          type = _getTextureParams.type;

      var weightsScale = floatTargetSupport ? 1 : 1 / 255;
      this.setState({
        textureSize: textureSize,
        format: format,
        type: type,
        weightsScale: weightsScale
      });

      if (!floatTargetSupport) {
        _core2.log.warn("HeatmapLayer: ".concat(this.id, " rendering to float texture not supported, fallingback to low precession format"))();
      }
    }
  }, {
    key: "_createWeightsTransform",
    value: function _createWeightsTransform() {
      var shaderOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var gl = this.context.gl;
      var weightsTransform = this.state.weightsTransform;
      var weightsTexture = this.state.weightsTexture;

      if (weightsTransform) {
        weightsTransform["delete"]();
      }

      var shaders = (0, _core2._mergeShaders)({
        vs: _weightsVs["default"],
        _fs: _weightsFs["default"],
        modules: [_core2.project32]
      }, shaderOptions);
      weightsTransform = new _core.Transform(gl, _objectSpread({
        id: "".concat(this.id, "-weights-transform"),
        elementCount: 1,
        _targetTexture: weightsTexture,
        _targetTextureVarying: 'weightsTexture'
      }, shaders));
      this.setState({
        weightsTransform: weightsTransform
      });
    }
  }, {
    key: "_setupResources",
    value: function _setupResources() {
      var gl = this.context.gl;

      this._createTextures();

      var _this$state4 = this.state,
          textureSize = _this$state4.textureSize,
          weightsTexture = _this$state4.weightsTexture,
          maxWeightsTexture = _this$state4.maxWeightsTexture;

      this._createWeightsTransform();

      var maxWeightTransform = new _core.Transform(gl, {
        id: "".concat(this.id, "-max-weights-transform"),
        _sourceTextures: {
          inTexture: weightsTexture
        },
        _targetTexture: maxWeightsTexture,
        _targetTextureVarying: 'outTexture',
        vs: _maxVs["default"],
        elementCount: textureSize * textureSize
      });
      this.setState({
        weightsTexture: weightsTexture,
        maxWeightsTexture: maxWeightsTexture,
        maxWeightTransform: maxWeightTransform,
        zoom: null,
        triPositionBuffer: new _core.Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 3
          }
        }),
        triTexCoordBuffer: new _core.Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 2
          }
        })
      });
    }
  }, {
    key: "updateShaders",
    value: function updateShaders(shaderOptions) {
      this._createWeightsTransform(shaderOptions);
    }
  }, {
    key: "_updateMaxWeightValue",
    value: function _updateMaxWeightValue() {
      var maxWeightTransform = this.state.maxWeightTransform;
      maxWeightTransform.run({
        parameters: {
          blend: true,
          depthTest: false,
          blendFunc: [1, 1],
          blendEquation: 32776
        }
      });
    }
  }, {
    key: "_updateBounds",
    value: function _updateBounds() {
      var forceUpdate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var viewport = this.context.viewport;
      var viewportCorners = [viewport.unproject([0, 0]), viewport.unproject([viewport.width, 0]), viewport.unproject([viewport.width, viewport.height]), viewport.unproject([0, viewport.height])];
      var visibleWorldBounds = (0, _heatmapLayerUtils.getBounds)(viewportCorners);
      var newState = {
        visibleWorldBounds: visibleWorldBounds,
        viewportCorners: viewportCorners
      };
      var boundsChanged = false;

      if (forceUpdate || !this.state.worldBounds || !(0, _heatmapLayerUtils.boundsContain)(this.state.worldBounds, visibleWorldBounds)) {
        var scaledCommonBounds = this._worldToCommonBounds(visibleWorldBounds);

        var worldBounds = this._commonToWorldBounds(scaledCommonBounds);

        if (this.props.coordinateSystem === _core2.COORDINATE_SYSTEM.LNGLAT) {
          worldBounds[1] = Math.max(worldBounds[1], -85.051129);
          worldBounds[3] = Math.min(worldBounds[3], 85.051129);
          worldBounds[0] = Math.max(worldBounds[0], -360);
          worldBounds[2] = Math.min(worldBounds[2], 360);
        }

        var normalizedCommonBounds = this._worldToCommonBounds(worldBounds);

        newState.worldBounds = worldBounds;
        newState.normalizedCommonBounds = normalizedCommonBounds;
        boundsChanged = true;
      }

      this.setState(newState);
      return boundsChanged;
    }
  }, {
    key: "_updateTextureRenderingBounds",
    value: function _updateTextureRenderingBounds() {
      var _this$state5 = this.state,
          triPositionBuffer = _this$state5.triPositionBuffer,
          triTexCoordBuffer = _this$state5.triTexCoordBuffer,
          normalizedCommonBounds = _this$state5.normalizedCommonBounds,
          viewportCorners = _this$state5.viewportCorners;
      var viewport = this.context.viewport;
      triPositionBuffer.subData((0, _heatmapLayerUtils.packVertices)(viewportCorners, 3));
      var textureBounds = viewportCorners.map(function (p) {
        return (0, _heatmapLayerUtils.getTextureCoordinates)(viewport.projectPosition(p), normalizedCommonBounds);
      });
      triTexCoordBuffer.subData((0, _heatmapLayerUtils.packVertices)(textureBounds, 2));
    }
  }, {
    key: "_updateColorTexture",
    value: function _updateColorTexture(opts) {
      var colorRange = opts.props.colorRange;
      var colorTexture = this.state.colorTexture;
      var colors = (0, _colorUtils.colorRangeToFlatArray)(colorRange, true);

      if (colorTexture) {
        colorTexture.setImageData({
          data: colors,
          width: colorRange.length
        });
      } else {
        colorTexture = new _core.Texture2D(this.context.gl, _objectSpread({
          data: colors,
          width: colorRange.length,
          height: 1,
          format: (0, _core.isWebGL2)(this.context.gl) ? 34836 : 6408,
          type: 5126
        }, TEXTURE_OPTIONS));
      }

      this.setState({
        colorTexture: colorTexture
      });
    }
  }, {
    key: "_updateWeightmap",
    value: function _updateWeightmap() {
      var _weightsTexture$setPa;

      var radiusPixels = this.props.radiusPixels;
      var _this$state6 = this.state,
          weightsTransform = _this$state6.weightsTransform,
          worldBounds = _this$state6.worldBounds,
          textureSize = _this$state6.textureSize,
          weightsTexture = _this$state6.weightsTexture,
          weightsScale = _this$state6.weightsScale;

      var commonBounds = this._worldToCommonBounds(worldBounds, {
        useLayerCoordinateSystem: true
      });

      var uniforms = {
        radiusPixels: radiusPixels,
        commonBounds: commonBounds,
        textureWidth: textureSize,
        weightsScale: weightsScale
      };
      weightsTransform.update({
        elementCount: this.getNumInstances()
      });
      weightsTransform.run({
        uniforms: uniforms,
        parameters: {
          blend: true,
          depthTest: false,
          blendFunc: [1, 1],
          blendEquation: 32774
        },
        clearRenderTarget: true,
        attributes: this.getAttributes(),
        moduleSettings: this.getModuleSettings()
      });

      this._updateMaxWeightValue();

      weightsTexture.setParameters((_weightsTexture$setPa = {}, (0, _defineProperty2["default"])(_weightsTexture$setPa, 10240, 9729), (0, _defineProperty2["default"])(_weightsTexture$setPa, 10241, 9729), _weightsTexture$setPa));
      this.setState({
        lastUpdate: Date.now()
      });
    }
  }, {
    key: "_debouncedUpdateWeightmap",
    value: function _debouncedUpdateWeightmap() {
      var fromTimer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var updateTimer = this.state.updateTimer;
      var timeSinceLastUpdate = Date.now() - this.state.lastUpdate;

      if (fromTimer) {
        updateTimer = null;
      }

      if (timeSinceLastUpdate >= ZOOM_DEBOUNCE) {
        this._updateBounds(true);

        this._updateWeightmap();

        this._updateTextureRenderingBounds();
      } else if (!updateTimer) {
        updateTimer = setTimeout(this._debouncedUpdateWeightmap.bind(this, true), ZOOM_DEBOUNCE - timeSinceLastUpdate);
      }

      this.setState({
        updateTimer: updateTimer
      });
    }
  }, {
    key: "_worldToCommonBounds",
    value: function _worldToCommonBounds(worldBounds) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _opts$useLayerCoordin = opts.useLayerCoordinateSystem,
          useLayerCoordinateSystem = _opts$useLayerCoordin === void 0 ? false : _opts$useLayerCoordin;

      var _worldBounds = (0, _slicedToArray2["default"])(worldBounds, 4),
          minLong = _worldBounds[0],
          minLat = _worldBounds[1],
          maxLong = _worldBounds[2],
          maxLat = _worldBounds[3];

      var viewport = this.context.viewport;
      var textureSize = this.state.textureSize;
      var size = textureSize * RESOLUTION / viewport.scale;
      var bottomLeftCommon;
      var topRightCommon;

      if (useLayerCoordinateSystem) {
        bottomLeftCommon = this.projectPosition([minLong, minLat, 0]);
        topRightCommon = this.projectPosition([maxLong, maxLat, 0]);
      } else {
        bottomLeftCommon = viewport.projectPosition([minLong, minLat, 0]);
        topRightCommon = viewport.projectPosition([maxLong, maxLat, 0]);
      }

      var commonBounds = bottomLeftCommon.slice(0, 2).concat(topRightCommon.slice(0, 2));
      commonBounds = (0, _heatmapLayerUtils.scaleToAspectRatio)(commonBounds, size, size);
      return commonBounds;
    }
  }, {
    key: "_commonToWorldBounds",
    value: function _commonToWorldBounds(commonBounds) {
      var _commonBounds = (0, _slicedToArray2["default"])(commonBounds, 4),
          xMin = _commonBounds[0],
          yMin = _commonBounds[1],
          xMax = _commonBounds[2],
          yMax = _commonBounds[3];

      var viewport = this.context.viewport;
      var bottomLeftWorld = viewport.unprojectPosition([xMin, yMin]);
      var topRightWorld = viewport.unprojectPosition([xMax, yMax]);
      return bottomLeftWorld.slice(0, 2).concat(topRightWorld.slice(0, 2));
    }
  }]);
  return HeatmapLayer;
}(_aggregationLayer["default"]);

exports["default"] = HeatmapLayer;
HeatmapLayer.layerName = 'HeatmapLayer';
HeatmapLayer.defaultProps = defaultProps;
//# sourceMappingURL=heatmap-layer.js.map