"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pointToHexbin = pointToHexbin;
exports.getPointsCenter = getPointsCenter;
exports.getRadiusInCommon = getRadiusInCommon;

var _d3Hexbin = require("d3-hexbin");

var _core = require("@deck.gl/core");

function pointToHexbin(props, aggregationParams) {
  var data = props.data,
      radius = props.radius;
  var viewport = aggregationParams.viewport,
      attributes = aggregationParams.attributes;
  var centerLngLat = data.length ? getPointsCenter(data, aggregationParams) : null;
  var radiusCommon = getRadiusInCommon(radius, viewport, centerLngLat);
  var screenPoints = [];

  var _createIterable = (0, _core.createIterable)(data),
      iterable = _createIterable.iterable,
      objectInfo = _createIterable.objectInfo;

  var positions = attributes.positions.value;

  var _attributes$positions = attributes.positions.getAccessor(),
      size = _attributes$positions.size;

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = iterable[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var object = _step.value;
      objectInfo.index++;
      var posIndex = objectInfo.index * size;
      var position = [positions[posIndex], positions[posIndex + 1]];
      var arrayIsFinite = Number.isFinite(position[0]) && Number.isFinite(position[1]);

      if (arrayIsFinite) {
        screenPoints.push(Object.assign({
          screenCoord: viewport.projectFlat(position)
        }, object));
      } else {
        _core.log.warn('HexagonLayer: invalid position')();
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  var newHexbin = (0, _d3Hexbin.hexbin)().radius(radiusCommon).x(function (d) {
    return d.screenCoord[0];
  }).y(function (d) {
    return d.screenCoord[1];
  });
  var hexagonBins = newHexbin(screenPoints);
  return {
    hexagons: hexagonBins.map(function (hex, index) {
      return {
        position: viewport.unprojectFlat([hex.x, hex.y]),
        points: hex,
        index: index
      };
    }),
    radiusCommon: radiusCommon
  };
}

function getPointsCenter(data, aggregationParams) {
  var attributes = aggregationParams.attributes;
  var positions = attributes.positions.value;

  var _attributes$positions2 = attributes.positions.getAccessor(),
      size = _attributes$positions2.size;

  var minX = Infinity;
  var minY = Infinity;
  var maxX = -Infinity;
  var maxY = -Infinity;
  var i;

  for (i = 0; i < size * data.length; i += size) {
    var x = positions[i];
    var y = positions[i + 1];
    var arrayIsFinite = Number.isFinite(x) && Number.isFinite(y);

    if (arrayIsFinite) {
      minX = Math.min(x, minX);
      maxX = Math.max(x, maxX);
      minY = Math.min(y, minY);
      maxY = Math.max(y, maxY);
    }
  }

  return [minX, minY, maxX, maxY].every(Number.isFinite) ? [(minX + maxX) / 2, (minY + maxY) / 2] : null;
}

function getRadiusInCommon(radius, viewport, center) {
  var _viewport$getDistance = viewport.getDistanceScales(center),
      unitsPerMeter = _viewport$getDistance.unitsPerMeter;

  return radius * unitsPerMeter[0];
}
//# sourceMappingURL=hexagon-aggregator.js.map