"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _colorUtils = require("../utils/color-utils");

var _screenGridLayerVertex = _interopRequireDefault(require("./screen-grid-layer-vertex.glsl"));

var _screenGridLayerFragment = _interopRequireDefault(require("./screen-grid-layer-fragment.glsl"));

var DEFAULT_MINCOLOR = [0, 0, 0, 0];
var DEFAULT_MAXCOLOR = [0, 255, 0, 255];
var COLOR_PROPS = ["minColor", "maxColor", "colorRange", "colorDomain"];
var defaultProps = {
  cellSizePixels: {
    value: 100,
    min: 1
  },
  cellMarginPixels: {
    value: 2,
    min: 0,
    max: 5
  },
  colorDomain: null,
  colorRange: _colorUtils.defaultColorRange
};

var ScreenGridCellLayer = function (_Layer) {
  (0, _inherits2["default"])(ScreenGridCellLayer, _Layer);

  function ScreenGridCellLayer() {
    (0, _classCallCheck2["default"])(this, ScreenGridCellLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(ScreenGridCellLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(ScreenGridCellLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        vs: _screenGridLayerVertex["default"],
        fs: _screenGridLayerFragment["default"],
        modules: [_core2.picking]
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var gl = this.context.gl;
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          update: this.calculateInstancePositions
        },
        instanceCounts: {
          size: 4,
          noAlloc: true
        }
      });
      this.setState({
        model: this._getModel(gl)
      });
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2) {
      var oldProps = _ref2.oldProps,
          props = _ref2.props,
          changeFlags = _ref2.changeFlags;
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(ScreenGridCellLayer.prototype), "updateState", this).call(this, {
        oldProps: oldProps,
        props: props,
        changeFlags: changeFlags
      });
      var attributeManager = this.getAttributeManager();

      if (props.numInstances !== oldProps.numInstances) {
        attributeManager.invalidateAll();
      } else if (oldProps.cellSizePixels !== props.cellSizePixels) {
        attributeManager.invalidate('instancePositions');
      }

      this._updateUniforms(oldProps, props, changeFlags);
    }
  }, {
    key: "draw",
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _this$props = this.props,
          parameters = _this$props.parameters,
          maxTexture = _this$props.maxTexture;
      var minColor = this.props.minColor || DEFAULT_MINCOLOR;
      var maxColor = this.props.maxColor || DEFAULT_MAXCOLOR;
      var colorDomain = this.props.colorDomain || [1, 0];
      var model = this.state.model;
      var layerUniforms = {
        minColor: minColor,
        maxColor: maxColor,
        maxTexture: maxTexture,
        colorDomain: colorDomain
      };
      uniforms = Object.assign(layerUniforms, uniforms);
      model.draw({
        uniforms: uniforms,
        parameters: Object.assign({
          depthTest: false,
          depthMask: false
        }, parameters)
      });
    }
  }, {
    key: "calculateInstancePositions",
    value: function calculateInstancePositions(attribute, _ref4) {
      var numInstances = _ref4.numInstances;
      var _this$context$viewpor = this.context.viewport,
          width = _this$context$viewpor.width,
          height = _this$context$viewpor.height;
      var cellSizePixels = this.props.cellSizePixels;
      var numCol = Math.ceil(width / cellSizePixels);
      var value = attribute.value,
          size = attribute.size;

      for (var i = 0; i < numInstances; i++) {
        var x = i % numCol;
        var y = Math.floor(i / numCol);
        value[i * size + 0] = x * cellSizePixels / width * 2 - 1;
        value[i * size + 1] = 1 - y * cellSizePixels / height * 2;
        value[i * size + 2] = 0;
      }
    }
  }, {
    key: "_getModel",
    value: function _getModel(gl) {
      return new _core.Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new _core.Geometry({
          drawMode: 6,
          attributes: {
            positions: new Float32Array([0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0])
          }
        }),
        isInstanced: true
      }));
    }
  }, {
    key: "_shouldUseMinMax",
    value: function _shouldUseMinMax() {
      var _this$props2 = this.props,
          minColor = _this$props2.minColor,
          maxColor = _this$props2.maxColor,
          colorDomain = _this$props2.colorDomain,
          colorRange = _this$props2.colorRange;

      if (minColor || maxColor) {
        _core2.log.deprecated('ScreenGridLayer props: minColor and maxColor', 'colorRange, colorDomain')();

        return true;
      }

      if (colorDomain || colorRange) {
        return false;
      }

      return true;
    }
  }, {
    key: "_updateUniforms",
    value: function _updateUniforms(oldProps, props, changeFlags) {
      var model = this.state.model;

      if (COLOR_PROPS.some(function (key) {
        return oldProps[key] !== props[key];
      })) {
        model.setUniforms({
          shouldUseMinMax: this._shouldUseMinMax()
        });
      }

      if (oldProps.colorRange !== props.colorRange) {
        model.setUniforms({
          colorRange: (0, _colorUtils.colorRangeToFlatArray)(props.colorRange)
        });
      }

      if (oldProps.cellMarginPixels !== props.cellMarginPixels || oldProps.cellSizePixels !== props.cellSizePixels || changeFlags.viewportChanged) {
        var _this$context$viewpor2 = this.context.viewport,
            width = _this$context$viewpor2.width,
            height = _this$context$viewpor2.height;
        var _this$props3 = this.props,
            cellSizePixels = _this$props3.cellSizePixels,
            cellMarginPixels = _this$props3.cellMarginPixels;
        var margin = cellSizePixels > cellMarginPixels ? cellMarginPixels : 0;
        var cellScale = new Float32Array([(cellSizePixels - margin) / width * 2, -(cellSizePixels - margin) / height * 2, 1]);
        model.setUniforms({
          cellScale: cellScale
        });
      }
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      return (0, _core.hasFeatures)(gl, [_core.FEATURES.TEXTURE_FLOAT]);
    }
  }]);
  return ScreenGridCellLayer;
}(_core2.Layer);

exports["default"] = ScreenGridCellLayer;
ScreenGridCellLayer.layerName = 'ScreenGridCellLayer';
ScreenGridCellLayer.defaultProps = defaultProps;
//# sourceMappingURL=screen-grid-cell-layer.js.map