"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _scaleUtils = require("./scale-utils");

var defaultGetValue = function defaultGetValue(points) {
  return points.length;
};

var MAX_32_BIT_FLOAT = 3.402823466e38;

var defaultGetPoints = function defaultGetPoints(bin) {
  return bin.points;
};

var defaultGetIndex = function defaultGetIndex(bin) {
  return bin.index;
};

var ascending = function ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
};

var defaultProps = {
  getValue: defaultGetValue,
  getPoints: defaultGetPoints,
  getIndex: defaultGetIndex,
  filterData: null
};

var BinSorter = function () {
  function BinSorter() {
    var bins = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : defaultProps;
    (0, _classCallCheck2["default"])(this, BinSorter);
    this.aggregatedBins = this.getAggregatedBins(bins, props);

    this._updateMinMaxValues();

    this.binMap = this.getBinMap();
  }

  (0, _createClass2["default"])(BinSorter, [{
    key: "getAggregatedBins",
    value: function getAggregatedBins(bins, props) {
      var _props$getValue = props.getValue,
          getValue = _props$getValue === void 0 ? defaultGetValue : _props$getValue,
          _props$getPoints = props.getPoints,
          getPoints = _props$getPoints === void 0 ? defaultGetPoints : _props$getPoints,
          _props$getIndex = props.getIndex,
          getIndex = _props$getIndex === void 0 ? defaultGetIndex : _props$getIndex,
          filterData = props.filterData;
      var hasFilter = typeof filterData === 'function';
      var binCount = bins.length;
      var aggregatedBins = [];
      var index = 0;

      for (var binIndex = 0; binIndex < binCount; binIndex++) {
        var bin = bins[binIndex];
        var points = getPoints(bin);
        var i = getIndex(bin);
        var filteredPoints = hasFilter ? points.filter(filterData) : points;
        bin.filteredPoints = hasFilter ? filteredPoints : null;
        var value = filteredPoints.length ? getValue(filteredPoints) : null;

        if (value !== null && value !== undefined) {
          aggregatedBins[index] = {
            i: Number.isFinite(i) ? i : binIndex,
            value: value,
            counts: filteredPoints.length
          };
          index++;
        }
      }

      return aggregatedBins;
    }
  }, {
    key: "_percentileToIndex",
    value: function _percentileToIndex(percentileRange) {
      var len = this.sortedBins.length;

      if (len < 2) {
        return [0, 0];
      }

      var _percentileRange$map = percentileRange.map(function (n) {
        return (0, _scaleUtils.clamp)(n, 0, 100);
      }),
          _percentileRange$map2 = (0, _slicedToArray2["default"])(_percentileRange$map, 2),
          lower = _percentileRange$map2[0],
          upper = _percentileRange$map2[1];

      var lowerIdx = Math.ceil(lower / 100 * (len - 1));
      var upperIdx = Math.floor(upper / 100 * (len - 1));
      return [lowerIdx, upperIdx];
    }
  }, {
    key: "getBinMap",
    value: function getBinMap() {
      var binMap = {};
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.aggregatedBins[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var bin = _step.value;
          binMap[bin.i] = bin;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return binMap;
    }
  }, {
    key: "_updateMinMaxValues",
    value: function _updateMinMaxValues() {
      var maxCount = 0;
      var maxValue = 0;
      var minValue = MAX_32_BIT_FLOAT;
      var totalCount = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this.aggregatedBins[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var x = _step2.value;
          maxCount = maxCount > x.counts ? maxCount : x.counts;
          maxValue = maxValue > x.value ? maxValue : x.value;
          minValue = minValue < x.value ? minValue : x.value;
          totalCount += x.counts;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      this.maxCount = maxCount;
      this.maxValue = maxValue;
      this.minValue = minValue;
      this.totalCount = totalCount;
    }
  }, {
    key: "getValueRange",
    value: function getValueRange(percentileRange) {
      if (!this.sortedBins) {
        this.sortedBins = this.aggregatedBins.sort(function (a, b) {
          return ascending(a.value, b.value);
        });
      }

      if (!this.sortedBins.length) {
        return [];
      }

      var lowerIdx = 0;
      var upperIdx = this.sortedBins.length - 1;

      if (Array.isArray(percentileRange)) {
        var idxRange = this._percentileToIndex(percentileRange);

        lowerIdx = idxRange[0];
        upperIdx = idxRange[1];
      }

      return [this.sortedBins[lowerIdx].value, this.sortedBins[upperIdx].value];
    }
  }, {
    key: "getValueDomainByScale",
    value: function getValueDomainByScale(scale) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [],
          _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
          _ref2$ = _ref2[0],
          lower = _ref2$ === void 0 ? 0 : _ref2$,
          _ref2$2 = _ref2[1],
          upper = _ref2$2 === void 0 ? 100 : _ref2$2;

      if (!this.sortedBins) {
        this.sortedBins = this.aggregatedBins.sort(function (a, b) {
          return ascending(a.value, b.value);
        });
      }

      if (!this.sortedBins.length) {
        return [];
      }

      var indexEdge = this._percentileToIndex([lower, upper]);

      return this._getScaleDomain(scale, indexEdge);
    }
  }, {
    key: "_getScaleDomain",
    value: function _getScaleDomain(scaleType, _ref3) {
      var _ref4 = (0, _slicedToArray2["default"])(_ref3, 2),
          lowerIdx = _ref4[0],
          upperIdx = _ref4[1];

      var bins = this.sortedBins;

      switch (scaleType) {
        case 'quantize':
        case 'linear':
          return [bins[lowerIdx].value, bins[upperIdx].value];

        case 'quantile':
          return (0, _scaleUtils.getQuantileDomain)(bins.slice(lowerIdx, upperIdx + 1), function (d) {
            return d.value;
          });

        case 'ordinal':
          return (0, _scaleUtils.getOrdinalDomain)(bins, function (d) {
            return d.value;
          });

        default:
          return [bins[lowerIdx].value, bins[upperIdx].value];
      }
    }
  }]);
  return BinSorter;
}();

exports["default"] = BinSorter;
//# sourceMappingURL=bin-sorter.js.map