import { hexbin } from 'd3-hexbin';
import { createIterable, log } from '@deck.gl/core';
export function pointToHexbin(props, aggregationParams) {
  const {
    data,
    radius
  } = props;
  const {
    viewport,
    attributes
  } = aggregationParams;
  const centerLngLat = data.length ? getPointsCenter(data, aggregationParams) : null;
  const radiusCommon = getRadiusInCommon(radius, viewport, centerLngLat);
  const screenPoints = [];
  const {
    iterable,
    objectInfo
  } = createIterable(data);
  const positions = attributes.positions.value;
  const {
    size
  } = attributes.positions.getAccessor();

  for (const object of iterable) {
    objectInfo.index++;
    const posIndex = objectInfo.index * size;
    const position = [positions[posIndex], positions[posIndex + 1]];
    const arrayIsFinite = Number.isFinite(position[0]) && Number.isFinite(position[1]);

    if (arrayIsFinite) {
      screenPoints.push(Object.assign({
        screenCoord: viewport.projectFlat(position)
      }, object));
    } else {
      log.warn('HexagonLayer: invalid position')();
    }
  }

  const newHexbin = hexbin().radius(radiusCommon).x(d => d.screenCoord[0]).y(d => d.screenCoord[1]);
  const hexagonBins = newHexbin(screenPoints);
  return {
    hexagons: hexagonBins.map((hex, index) => ({
      position: viewport.unprojectFlat([hex.x, hex.y]),
      points: hex,
      index
    })),
    radiusCommon
  };
}
export function getPointsCenter(data, aggregationParams) {
  const {
    attributes
  } = aggregationParams;
  const positions = attributes.positions.value;
  const {
    size
  } = attributes.positions.getAccessor();
  let minX = Infinity;
  let minY = Infinity;
  let maxX = -Infinity;
  let maxY = -Infinity;
  let i;

  for (i = 0; i < size * data.length; i += size) {
    const x = positions[i];
    const y = positions[i + 1];
    const arrayIsFinite = Number.isFinite(x) && Number.isFinite(y);

    if (arrayIsFinite) {
      minX = Math.min(x, minX);
      maxX = Math.max(x, maxX);
      minY = Math.min(y, minY);
      maxY = Math.max(y, maxY);
    }
  }

  return [minX, minY, maxX, maxY].every(Number.isFinite) ? [(minX + maxX) / 2, (minY + maxY) / 2] : null;
}
export function getRadiusInCommon(radius, viewport, center) {
  const {
    unitsPerMeter
  } = viewport.getDistanceScales(center);
  return radius * unitsPerMeter[0];
}
//# sourceMappingURL=hexagon-aggregator.js.map