import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { log } from '@deck.gl/core';
import { ColumnLayer } from '@deck.gl/layers';
import { defaultColorRange } from '../utils/color-utils';
import { pointToHexbin } from './hexagon-aggregator';
import CPUAggregator from '../utils/cpu-aggregator';
import AggregationLayer from '../aggregation-layer';

function nop() {}

const defaultProps = {
  colorDomain: null,
  colorRange: defaultColorRange,
  getColorValue: {
    type: 'accessor',
    value: null
  },
  getColorWeight: {
    type: 'accessor',
    value: x => 1
  },
  colorAggregation: 'SUM',
  lowerPercentile: {
    type: 'number',
    value: 0,
    min: 0,
    max: 100
  },
  upperPercentile: {
    type: 'number',
    value: 100,
    min: 0,
    max: 100
  },
  colorScaleType: 'quantize',
  onSetColorDomain: nop,
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationValue: {
    type: 'accessor',
    value: null
  },
  getElevationWeight: {
    type: 'accessor',
    value: x => 1
  },
  elevationAggregation: 'SUM',
  elevationLowerPercentile: {
    type: 'number',
    value: 0,
    min: 0,
    max: 100
  },
  elevationUpperPercentile: {
    type: 'number',
    value: 100,
    min: 0,
    max: 100
  },
  elevationScale: {
    type: 'number',
    min: 0,
    value: 1
  },
  elevationScaleType: 'linear',
  onSetElevationDomain: nop,
  radius: {
    type: 'number',
    value: 1000,
    min: 1
  },
  coverage: {
    type: 'number',
    min: 0,
    max: 1,
    value: 1
  },
  extruded: false,
  hexagonAggregator: pointToHexbin,
  getPosition: {
    type: 'accessor',
    value: x => x.position
  },
  material: true,
  _filterData: {
    type: 'function',
    value: null,
    optional: true
  }
};
export default class HexagonLayer extends AggregationLayer {
  shouldUpdateState({
    changeFlags
  }) {
    return changeFlags.somethingChanged;
  }

  initializeState() {
    const cpuAggregator = new CPUAggregator({
      getAggregator: props => props.hexagonAggregator,
      getCellSize: props => props.radius
    });
    this.state = {
      cpuAggregator,
      aggregatorState: cpuAggregator.state,
      hexagonVertices: null
    };
    const attributeManager = this.getAttributeManager();
    attributeManager.add({
      positions: {
        size: 3,
        accessor: 'getPosition'
      }
    });
  }

  updateState(opts) {
    super.updateState(opts);
    const {
      cpuAggregator,
      hexagonVertices: oldVertices
    } = this.state;

    if (opts.changeFlags.propsOrDataChanged) {
      this.setState({
        aggregatorState: cpuAggregator.updateState(opts, {
          viewport: this.context.viewport,
          attributes: this.getAttributes()
        })
      });
    }

    const {
      hexagonVertices
    } = cpuAggregator.state.layerData || {};

    if (hexagonVertices && oldVertices !== hexagonVertices) {
      const vertices = this.convertLatLngToMeterOffset(hexagonVertices);

      if (vertices) {
        this.setState({
          hexagonVertices,
          vertices
        });
      }
    } else {
      this.updateRadiusAngle();
    }
  }

  updateRadiusAngle(vertices) {
    const {
      viewport
    } = this.context;
    const {
      unitsPerMeter
    } = viewport.getDistanceScales();
    const {
      cpuAggregator
    } = this.state;

    if (cpuAggregator.state.layerData && cpuAggregator.state.layerData.radiusCommon) {
      const {
        radiusCommon
      } = cpuAggregator.state.layerData;
      const radius = radiusCommon / unitsPerMeter[0];
      this.setState({
        angle: 90,
        radius
      });
    }
  }

  convertLatLngToMeterOffset(hexagonVertices) {
    const {
      viewport
    } = this.context;

    if (Array.isArray(hexagonVertices) && hexagonVertices.length === 6) {
      const vertex0 = hexagonVertices[0];
      const vertex3 = hexagonVertices[3];
      const centroid = [(vertex0[0] + vertex3[0]) / 2, (vertex0[1] + vertex3[1]) / 2];
      const centroidFlat = viewport.projectFlat(centroid);
      const {
        metersPerUnit
      } = viewport.getDistanceScales(centroid);
      const vertices = hexagonVertices.map(vt => {
        const vtFlat = viewport.projectFlat(vt);
        return [(vtFlat[0] - centroidFlat[0]) * metersPerUnit[0], (vtFlat[1] - centroidFlat[1]) * metersPerUnit[1]];
      });
      return vertices;
    }

    log.error('HexagonLayer: hexagonVertices needs to be an array of 6 points')();
    return null;
  }

  getPickingInfo({
    info
  }) {
    return this.state.cpuAggregator.getPickingInfo({
      info
    });
  }

  _onGetSublayerColor(cell) {
    return this.state.cpuAggregator.getAccessor('fillColor')(cell);
  }

  _onGetSublayerElevation(cell) {
    return this.state.cpuAggregator.getAccessor('elevation')(cell);
  }

  _getSublayerUpdateTriggers() {
    return this.state.cpuAggregator.getUpdateTriggers(this.props);
  }

  renderLayers() {
    const {
      elevationScale,
      extruded,
      coverage,
      material,
      transitions
    } = this.props;
    const {
      angle,
      radius,
      cpuAggregator,
      vertices
    } = this.state;
    const SubLayerClass = this.getSubLayerClass('hexagon-cell', ColumnLayer);

    const updateTriggers = this._getSublayerUpdateTriggers();

    const geometry = vertices && vertices.length ? {
      vertices,
      radius: 1
    } : {
      radius,
      angle
    };
    return new SubLayerClass(_objectSpread({}, geometry, {
      diskResolution: 6,
      elevationScale,
      extruded,
      coverage,
      material,
      getFillColor: this._onGetSublayerColor.bind(this),
      getElevation: this._onGetSublayerElevation.bind(this),
      transitions: transitions && {
        getFillColor: transitions.getColorValue || transitions.getColorWeight,
        getElevation: transitions.getElevationValue || transitions.getElevationWeight
      }
    }), this.getSubLayerProps({
      id: 'hexagon-cell',
      updateTriggers
    }), {
      data: cpuAggregator.state.layerData.data
    });
  }

}
HexagonLayer.layerName = 'HexagonLayer';
HexagonLayer.defaultProps = defaultProps;
//# sourceMappingURL=hexagon-layer.js.map