import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import AggregationLayer from './aggregation-layer';
import GPUGridAggregator from './utils/gpu-grid-aggregation/gpu-grid-aggregator';
import { Buffer } from '@luma.gl/core';
import { log } from '@deck.gl/core';
import BinSorter from './utils/bin-sorter';
import { pointToDensityGridDataCPU } from './cpu-grid-layer/grid-aggregator';

var GridAggregationLayer = function (_AggregationLayer) {
  _inherits(GridAggregationLayer, _AggregationLayer);

  function GridAggregationLayer() {
    _classCallCheck(this, GridAggregationLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(GridAggregationLayer).apply(this, arguments));
  }

  _createClass(GridAggregationLayer, [{
    key: "initializeState",
    value: function initializeState(_ref) {
      var dimensions = _ref.dimensions;
      var gl = this.context.gl;

      _get(_getPrototypeOf(GridAggregationLayer.prototype), "initializeState", this).call(this, dimensions);

      this.setState({
        layerData: {},
        gpuGridAggregator: new GPUGridAggregator(gl, {
          id: "".concat(this.id, "-gpu-aggregator")
        }),
        cpuGridAggregator: pointToDensityGridDataCPU
      });
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      _get(_getPrototypeOf(GridAggregationLayer.prototype), "updateState", this).call(this, opts);

      this.updateAggregationState(opts);
      var _this$state = this.state,
          aggregationDataDirty = _this$state.aggregationDataDirty,
          aggregationWeightsDirty = _this$state.aggregationWeightsDirty,
          gpuAggregation = _this$state.gpuAggregation;

      if (this.getNumInstances() <= 0) {
        return;
      }

      var aggregationDirty = false;

      if (aggregationDataDirty || gpuAggregation && aggregationWeightsDirty) {
        this._updateAggregation(opts);

        aggregationDirty = true;
      }

      if (!gpuAggregation && (aggregationDataDirty || aggregationWeightsDirty)) {
        this._updateWeightBins();

        this._uploadAggregationResults();

        aggregationDirty = true;
      }

      this.setState({
        aggregationDirty: aggregationDirty
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var count = this.state.weights.count;

      if (count && count.aggregationBuffer) {
        count.aggregationBuffer["delete"]();
      }

      var gpuGridAggregator = this.state.gpuGridAggregator;

      if (gpuGridAggregator) {
        gpuGridAggregator["delete"]();
      }

      _get(_getPrototypeOf(GridAggregationLayer.prototype), "finalizeState", this).call(this);
    }
  }, {
    key: "updateShaders",
    value: function updateShaders(shaders) {
      if (this.state.gpuAggregation) {
        this.state.gpuGridAggregator.updateShaders(shaders);
      }
    }
  }, {
    key: "updateAggregationState",
    value: function updateAggregationState(opts) {
      log.assert(false);
    }
  }, {
    key: "allocateResources",
    value: function allocateResources(numRow, numCol) {
      if (this.state.numRow !== numRow || this.state.numCol !== numCol) {
        var dataBytes = numCol * numRow * 4 * 4;
        var gl = this.context.gl;
        var weights = this.state.weights;

        for (var name in weights) {
          var weight = weights[name];

          if (weight.aggregationBuffer) {
            weight.aggregationBuffer["delete"]();
          }

          weight.aggregationBuffer = new Buffer(gl, {
            byteLength: dataBytes,
            accessor: {
              size: 4,
              type: 5126,
              divisor: 1
            }
          });
        }
      }
    }
  }, {
    key: "updateResults",
    value: function updateResults(_ref2) {
      var aggregationData = _ref2.aggregationData,
          maxMinData = _ref2.maxMinData,
          maxData = _ref2.maxData,
          minData = _ref2.minData;
      var count = this.state.weights.count;

      if (count) {
        count.aggregationData = aggregationData;
        count.maxMinData = maxMinData;
        count.maxData = maxData;
        count.minData = minData;
      }
    }
  }, {
    key: "_updateAggregation",
    value: function _updateAggregation(opts) {
      var _this$state2 = this.state,
          cpuGridAggregator = _this$state2.cpuGridAggregator,
          gpuGridAggregator = _this$state2.gpuGridAggregator,
          gridOffset = _this$state2.gridOffset,
          posOffset = _this$state2.posOffset,
          _this$state2$translat = _this$state2.translation,
          translation = _this$state2$translat === void 0 ? [0, 0] : _this$state2$translat,
          _this$state2$scaling = _this$state2.scaling,
          scaling = _this$state2$scaling === void 0 ? [0, 0, 0] : _this$state2$scaling,
          boundingBox = _this$state2.boundingBox,
          projectPoints = _this$state2.projectPoints,
          gpuAggregation = _this$state2.gpuAggregation,
          numCol = _this$state2.numCol,
          numRow = _this$state2.numRow;
      var props = opts.props;
      var viewport = this.context.viewport;
      var attributes = this.getAttributes();
      var vertexCount = this.getNumInstances();

      if (!gpuAggregation) {
        var result = cpuGridAggregator(props, {
          gridOffset: gridOffset,
          projectPoints: projectPoints,
          attributes: attributes,
          viewport: viewport,
          posOffset: posOffset,
          boundingBox: boundingBox
        });
        this.setState({
          layerData: result
        });
      } else {
        var weights = this.state.weights;
        gpuGridAggregator.run({
          weights: weights,
          cellSize: [gridOffset.xOffset, gridOffset.yOffset],
          numCol: numCol,
          numRow: numRow,
          translation: translation,
          scaling: scaling,
          vertexCount: vertexCount,
          projectPoints: projectPoints,
          attributes: attributes,
          moduleSettings: this.getModuleSettings()
        });
      }
    }
  }, {
    key: "_updateWeightBins",
    value: function _updateWeightBins() {
      var getValue = this.state.getValue;
      var sortedBins = new BinSorter(this.state.layerData.data || [], {
        getValue: getValue
      });
      this.setState({
        sortedBins: sortedBins
      });
    }
  }, {
    key: "_uploadAggregationResults",
    value: function _uploadAggregationResults() {
      var _this$state3 = this.state,
          numCol = _this$state3.numCol,
          numRow = _this$state3.numRow;
      var data = this.state.layerData.data;
      var _this$state$sortedBin = this.state.sortedBins,
          aggregatedBins = _this$state$sortedBin.aggregatedBins,
          minValue = _this$state$sortedBin.minValue,
          maxValue = _this$state$sortedBin.maxValue,
          totalCount = _this$state$sortedBin.totalCount;
      var ELEMENTCOUNT = 4;
      var aggregationSize = numCol * numRow * ELEMENTCOUNT;
      var aggregationData = new Float32Array(aggregationSize).fill(0);
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = aggregatedBins[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var bin = _step.value;
          var _data$bin$i = data[bin.i],
              lonIdx = _data$bin$i.lonIdx,
              latIdx = _data$bin$i.latIdx;
          var value = bin.value,
              counts = bin.counts;
          var cellIndex = (lonIdx + latIdx * numCol) * ELEMENTCOUNT;
          aggregationData[cellIndex] = value;
          aggregationData[cellIndex + ELEMENTCOUNT - 1] = counts;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      var maxMinData = new Float32Array([maxValue, 0, 0, minValue]);
      var maxData = new Float32Array([maxValue, 0, 0, totalCount]);
      var minData = new Float32Array([minValue, 0, 0, totalCount]);
      this.updateResults({
        aggregationData: aggregationData,
        maxMinData: maxMinData,
        maxData: maxData,
        minData: minData
      });
    }
  }]);

  return GridAggregationLayer;
}(AggregationLayer);

export { GridAggregationLayer as default };
GridAggregationLayer.layerName = 'GridAggregationLayer';
//# sourceMappingURL=grid-aggregation-layer.js.map