import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { Model, Geometry } from '@luma.gl/core';
import { Layer, project32 } from '@deck.gl/core';
import vs from './triangle-layer-vertex.glsl';
import fs from './triangle-layer-fragment.glsl';
var defaultProps = {
  count: 0,
  texture: null
};

var TriangleLayer = function (_Layer) {
  _inherits(TriangleLayer, _Layer);

  function TriangleLayer() {
    _classCallCheck(this, TriangleLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(TriangleLayer).apply(this, arguments));
  }

  _createClass(TriangleLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        vs: vs,
        fs: fs,
        modules: [project32]
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var gl = this.context.gl;
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          noAlloc: true
        },
        texCoords: {
          size: 2,
          noAlloc: true
        }
      });
      this.setState({
        model: this._getModel(gl)
      });
    }
  }, {
    key: "_getModel",
    value: function _getModel(gl) {
      var vertexCount = this.props.vertexCount;
      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: 6,
          vertexCount: vertexCount
        })
      }));
    }
  }, {
    key: "draw",
    value: function draw(_ref) {
      var uniforms = _ref.uniforms;
      var model = this.state.model;
      var _this$props = this.props,
          texture = _this$props.texture,
          maxTexture = _this$props.maxTexture,
          colorTexture = _this$props.colorTexture,
          intensity = _this$props.intensity,
          threshold = _this$props.threshold,
          colorDomain = _this$props.colorDomain;
      model.setUniforms(_objectSpread({}, uniforms, {
        texture: texture,
        maxTexture: maxTexture,
        colorTexture: colorTexture,
        intensity: intensity,
        threshold: threshold,
        colorDomain: colorDomain
      })).draw();
    }
  }]);

  return TriangleLayer;
}(Layer);

export { TriangleLayer as default };
TriangleLayer.layerName = 'TriangleLayer';
TriangleLayer.defaultProps = defaultProps;
//# sourceMappingURL=triangle-layer.js.map