import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import { log } from '@deck.gl/core';
import GPUGridAggregator from '../utils/gpu-grid-aggregation/gpu-grid-aggregator';
import { AGGREGATION_OPERATION, getValueFunc } from '../utils/aggregation-operation-utils';
import ScreenGridCellLayer from './screen-grid-cell-layer';
import GridAggregationLayer from '../grid-aggregation-layer';
import { getFloatTexture } from '../utils/resource-utils.js';
var defaultProps = Object.assign({}, ScreenGridCellLayer.defaultProps, {
  getPosition: {
    type: 'accessor',
    value: function value(d) {
      return d.position;
    }
  },
  getWeight: {
    type: 'accessor',
    value: function value(d) {
      return 1;
    }
  },
  gpuAggregation: true,
  aggregation: 'SUM'
});
var POSITION_ATTRIBUTE_NAME = 'positions';
var DIMENSIONS = {
  data: {
    props: ['cellSizePixels']
  },
  weights: {
    props: ['aggregation'],
    accessors: ['getWeight']
  }
};

var ScreenGridLayer = function (_GridAggregationLayer) {
  _inherits(ScreenGridLayer, _GridAggregationLayer);

  function ScreenGridLayer() {
    _classCallCheck(this, ScreenGridLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(ScreenGridLayer).apply(this, arguments));
  }

  _createClass(ScreenGridLayer, [{
    key: "initializeState",
    value: function initializeState() {
      var _attributeManager$add;

      var gl = this.context.gl;

      if (!ScreenGridCellLayer.isSupported(gl)) {
        this.setState({
          supported: false
        });
        log.error("ScreenGridLayer: ".concat(this.id, " is not supported on this browser"))();
        return;
      }

      _get(_getPrototypeOf(ScreenGridLayer.prototype), "initializeState", this).call(this, {
        dimensions: DIMENSIONS,
        getCellSize: function getCellSize(props) {
          return props.cellSizePixels;
        }
      });

      var weights = {
        count: {
          size: 1,
          operation: AGGREGATION_OPERATION.SUM,
          needMax: true,
          maxTexture: getFloatTexture(gl, {
            id: "".concat(this.id, "-max-texture")
          })
        }
      };
      this.setState({
        supported: true,
        projectPoints: true,
        weights: weights,
        subLayerData: {
          attributes: {}
        },
        maxTexture: weights.count.maxTexture,
        positionAttributeName: 'positions',
        posOffset: [0, 0],
        translation: [1, -1]
      });
      var attributeManager = this.getAttributeManager();
      attributeManager.add((_attributeManager$add = {}, _defineProperty(_attributeManager$add, POSITION_ATTRIBUTE_NAME, {
        size: 3,
        accessor: 'getPosition',
        type: 5130,
        fp64: this.use64bitPositions()
      }), _defineProperty(_attributeManager$add, "count", {
        size: 3,
        accessor: 'getWeight'
      }), _attributeManager$add));
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return this.state.supported && changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      _get(_getPrototypeOf(ScreenGridLayer.prototype), "updateState", this).call(this, opts);
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      if (!this.state.supported) {
        return [];
      }

      var _this$state = this.state,
          maxTexture = _this$state.maxTexture,
          numRow = _this$state.numRow,
          numCol = _this$state.numCol,
          weights = _this$state.weights;
      var updateTriggers = this.props.updateTriggers;
      var aggregationBuffer = weights.count.aggregationBuffer;
      var CellLayerClass = this.getSubLayerClass('cells', ScreenGridCellLayer);
      return new CellLayerClass(this.props, this.getSubLayerProps({
        id: 'cell-layer',
        updateTriggers: updateTriggers
      }), {
        data: {
          attributes: {
            instanceCounts: aggregationBuffer
          }
        },
        maxTexture: maxTexture,
        numInstances: numRow * numCol
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      _get(_getPrototypeOf(ScreenGridLayer.prototype), "finalizeState", this).call(this);

      var _this$state2 = this.state,
          aggregationBuffer = _this$state2.aggregationBuffer,
          maxBuffer = _this$state2.maxBuffer,
          maxTexture = _this$state2.maxTexture;

      if (aggregationBuffer) {
        aggregationBuffer["delete"]();
      }

      if (maxBuffer) {
        maxBuffer["delete"]();
      }

      if (maxTexture) {
        maxTexture["delete"]();
      }
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info,
          mode = _ref2.mode;
      var index = info.index;

      if (index >= 0) {
        var gpuGridAggregator = this.state.gpuGridAggregator;
        var aggregationResults = gpuGridAggregator.getData('count');
        info.object = GPUGridAggregator.getAggregationData(Object.assign({
          pixelIndex: index
        }, aggregationResults));
      }

      return info;
    }
  }, {
    key: "updateResults",
    value: function updateResults(_ref3) {
      var aggregationData = _ref3.aggregationData,
          maxData = _ref3.maxData;
      var count = this.state.weights.count;
      count.aggregationData = aggregationData;
      count.aggregationBuffer.setData({
        data: aggregationData
      });
      count.maxData = maxData;
      count.maxTexture.setImageData({
        data: maxData
      });
    }
  }, {
    key: "updateAggregationState",
    value: function updateAggregationState(opts) {
      var cellSize = opts.props.cellSizePixels;
      var cellSizeChanged = opts.oldProps.cellSizePixels !== cellSize;
      var viewportChanged = opts.changeFlags.viewportChanged;
      var gpuAggregation = opts.props.gpuAggregation;

      if (this.state.gpuAggregation !== opts.props.gpuAggregation) {
        if (gpuAggregation && !GPUGridAggregator.isSupported(this.context.gl)) {
          log.warn('GPU Grid Aggregation not supported, falling back to CPU')();
          gpuAggregation = false;
        }
      }

      var gpuAggregationChanged = gpuAggregation !== this.state.gpuAggregation;
      this.setState({
        gpuAggregation: gpuAggregation
      });
      var positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME);
      var dimensions = this.state.dimensions;
      var data = dimensions.data,
          weights = dimensions.weights;
      var aggregationDataDirty = positionsChanged || gpuAggregationChanged || viewportChanged || this.isAggregationDirty(opts, {
        compareAll: gpuAggregation,
        dimension: data
      });
      var aggregationWeightsDirty = this.isAggregationDirty(opts, {
        dimension: weights
      });
      this.setState({
        aggregationDataDirty: aggregationDataDirty,
        aggregationWeightsDirty: aggregationWeightsDirty
      });
      var viewport = this.context.viewport;

      if (viewportChanged || cellSizeChanged) {
        var width = viewport.width,
            height = viewport.height;
        var numCol = Math.ceil(width / cellSize);
        var numRow = Math.ceil(height / cellSize);
        this.allocateResources(numRow, numCol);
        this.setState({
          scaling: [width / 2, -height / 2, 1],
          gridOffset: {
            xOffset: cellSize,
            yOffset: cellSize
          },
          width: width,
          height: height,
          numCol: numCol,
          numRow: numRow
        });
      }

      if (aggregationWeightsDirty) {
        this._updateAccessors(opts);
      }

      if (aggregationDataDirty || aggregationWeightsDirty) {
        this._resetResults();
      }
    }
  }, {
    key: "_updateAccessors",
    value: function _updateAccessors(opts) {
      var _opts$props = opts.props,
          getWeight = _opts$props.getWeight,
          aggregation = _opts$props.aggregation;
      var count = this.state.weights.count;

      if (count) {
        count.getWeight = getWeight;
        count.operation = AGGREGATION_OPERATION[aggregation];
      }

      this.setState({
        getValue: getValueFunc(aggregation, getWeight)
      });
    }
  }, {
    key: "_resetResults",
    value: function _resetResults() {
      var count = this.state.weights.count;

      if (count) {
        count.aggregationData = null;
      }
    }
  }]);

  return ScreenGridLayer;
}(GridAggregationLayer);

export { ScreenGridLayer as default };
ScreenGridLayer.layerName = 'ScreenGridLayer';
ScreenGridLayer.defaultProps = defaultProps;
//# sourceMappingURL=screen-grid-layer.js.map