"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pointToDensityGridDataCPU = pointToDensityGridDataCPU;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _core = require("@deck.gl/core");

var _gridAggregationUtils = require("../utils/grid-aggregation-utils");

function pointToDensityGridDataCPU(props, aggregationParams) {
  var hashInfo = pointsToGridHashing(props, aggregationParams);
  var result = getGridLayerDataFromGridHash(hashInfo);
  return {
    gridHash: hashInfo.gridHash,
    gridOffset: hashInfo.gridOffset,
    data: result
  };
}

function pointsToGridHashing(props, aggregationParams) {
  var _props$data = props.data,
      data = _props$data === void 0 ? [] : _props$data,
      cellSize = props.cellSize;
  var attributes = aggregationParams.attributes,
      viewport = aggregationParams.viewport,
      projectPoints = aggregationParams.projectPoints,
      numInstances = aggregationParams.numInstances;
  var positions = attributes.positions.value;

  var _attributes$positions = attributes.positions.getAccessor(),
      size = _attributes$positions.size;

  var boundingBox = aggregationParams.boundingBox || getPositionBoundingBox(attributes.positions, numInstances);
  var offsets = aggregationParams.posOffset || [180, 90];
  var gridOffset = aggregationParams.gridOffset || (0, _gridAggregationUtils.getGridOffset)(boundingBox, cellSize);

  if (gridOffset.xOffset <= 0 || gridOffset.yOffset <= 0) {
    return {
      gridHash: {},
      gridOffset: gridOffset
    };
  }

  var width = viewport.width,
      height = viewport.height;
  var numCol = Math.ceil(width / gridOffset.xOffset);
  var numRow = Math.ceil(height / gridOffset.yOffset);
  var gridHash = {};

  var _createIterable = (0, _core.createIterable)(data),
      iterable = _createIterable.iterable,
      objectInfo = _createIterable.objectInfo;

  var position = new Array(3);
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = iterable[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var pt = _step.value;
      objectInfo.index++;
      position[0] = positions[objectInfo.index * size];
      position[1] = positions[objectInfo.index * size + 1];
      position[2] = size >= 3 ? positions[objectInfo.index * size + 2] : 0;

      var _ref = projectPoints ? viewport.project(position) : position,
          _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
          x = _ref2[0],
          y = _ref2[1];

      if (Number.isFinite(x) && Number.isFinite(y)) {
        var yIndex = Math.floor((y + offsets[1]) / gridOffset.yOffset);
        var xIndex = Math.floor((x + offsets[0]) / gridOffset.xOffset);

        if (!projectPoints || xIndex >= 0 && xIndex < numCol && yIndex >= 0 && yIndex < numRow) {
          var key = "".concat(yIndex, "-").concat(xIndex);
          gridHash[key] = gridHash[key] || {
            count: 0,
            points: [],
            lonIdx: xIndex,
            latIdx: yIndex
          };
          gridHash[key].count += 1;
          gridHash[key].points.push(pt);
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return {
    gridHash: gridHash,
    gridOffset: gridOffset,
    offsets: [offsets[0] * -1, offsets[1] * -1]
  };
}

function getGridLayerDataFromGridHash(_ref3) {
  var gridHash = _ref3.gridHash,
      gridOffset = _ref3.gridOffset,
      offsets = _ref3.offsets;
  var data = new Array(Object.keys(gridHash).length);
  var i = 0;

  for (var key in gridHash) {
    var idxs = key.split('-');
    var latIdx = parseInt(idxs[0], 10);
    var lonIdx = parseInt(idxs[1], 10);
    var index = i++;
    data[index] = Object.assign({
      index: index,
      position: [offsets[0] + gridOffset.xOffset * lonIdx, offsets[1] + gridOffset.yOffset * latIdx]
    }, gridHash[key]);
  }

  return data;
}

function getPositionBoundingBox(positionAttribute, numInstance) {
  var positions = positionAttribute.value;

  var _positionAttribute$ge = positionAttribute.getAccessor(),
      size = _positionAttribute$ge.size;

  var yMin = Infinity;
  var yMax = -Infinity;
  var xMin = Infinity;
  var xMax = -Infinity;
  var y;
  var x;

  for (var i = 0; i < numInstance; i++) {
    x = positions[i * size];
    y = positions[i * size + 1];

    if (Number.isFinite(x) && Number.isFinite(y)) {
      yMin = y < yMin ? y : yMin;
      yMax = y > yMax ? y : yMax;
      xMin = x < xMin ? x : xMin;
      xMax = x > xMax ? x : xMax;
    }
  }

  return {
    xMin: xMin,
    xMax: xMax,
    yMin: yMin,
    yMax: yMax
  };
}
//# sourceMappingURL=grid-aggregator.js.map