"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _gpuGridAggregator = _interopRequireDefault(require("../utils/gpu-grid-aggregation/gpu-grid-aggregator"));

var _aggregationOperationUtils = require("../utils/aggregation-operation-utils");

var _colorUtils = require("../utils/color-utils");

var _gpuGridCellLayer = _interopRequireDefault(require("./gpu-grid-cell-layer"));

var _gridAggregator = require("./../cpu-grid-layer/grid-aggregator");

var _gridAggregationLayer = _interopRequireDefault(require("../grid-aggregation-layer"));

var _gridAggregationUtils = require("../utils/grid-aggregation-utils");

var defaultProps = {
  colorDomain: null,
  colorRange: _colorUtils.defaultColorRange,
  getColorWeight: {
    type: 'accessor',
    value: function value(x) {
      return 1;
    }
  },
  colorAggregation: 'SUM',
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationWeight: {
    type: 'accessor',
    value: function value(x) {
      return 1;
    }
  },
  elevationAggregation: 'SUM',
  elevationScale: {
    type: 'number',
    min: 0,
    value: 1
  },
  cellSize: {
    type: 'number',
    min: 1,
    max: 1000,
    value: 1000
  },
  coverage: {
    type: 'number',
    min: 0,
    max: 1,
    value: 1
  },
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  extruded: false,
  material: true
};
var DIMENSIONS = {
  data: {
    props: ['cellSize', 'colorAggregation', 'elevationAggregation']
  }
};
var POSITION_ATTRIBUTE_NAME = 'positions';

var GPUGridLayer = function (_GridAggregationLayer) {
  (0, _inherits2["default"])(GPUGridLayer, _GridAggregationLayer);

  function GPUGridLayer() {
    (0, _classCallCheck2["default"])(this, GPUGridLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(GPUGridLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(GPUGridLayer, [{
    key: "initializeState",
    value: function initializeState() {
      var _attributeManager$add;

      var gl = this.context.gl;

      var isSupported = _gpuGridAggregator["default"].isSupported(gl);

      if (!isSupported) {
        _core2.log.error('GPUGridLayer is not supported on this browser, use GridLayer instead')();
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(GPUGridLayer.prototype), "initializeState", this).call(this, {
        dimensions: DIMENSIONS
      });
      this.setState({
        gpuAggregation: true,
        projectPoints: false,
        isSupported: isSupported,
        weights: {
          color: {
            needMin: true,
            needMax: true,
            combineMaxMin: true,
            maxMinBuffer: new _core.Buffer(gl, {
              byteLength: 4 * 4,
              accessor: {
                size: 4,
                type: 5126,
                divisor: 1
              }
            })
          },
          elevation: {
            needMin: true,
            needMax: true,
            combineMaxMin: true,
            maxMinBuffer: new _core.Buffer(gl, {
              byteLength: 4 * 4,
              accessor: {
                size: 4,
                type: 5126,
                divisor: 1
              }
            })
          }
        },
        positionAttributeName: 'positions'
      });
      var attributeManager = this.getAttributeManager();
      attributeManager.add((_attributeManager$add = {}, (0, _defineProperty2["default"])(_attributeManager$add, POSITION_ATTRIBUTE_NAME, {
        size: 3,
        accessor: 'getPosition',
        type: 5130,
        fp64: this.use64bitPositions()
      }), (0, _defineProperty2["default"])(_attributeManager$add, "color", {
        size: 3,
        accessor: 'getColorWeight'
      }), (0, _defineProperty2["default"])(_attributeManager$add, "elevation", {
        size: 3,
        accessor: 'getElevationWeight'
      }), _attributeManager$add));
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      if (this.state.isSupported === false) {
        return;
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(GPUGridLayer.prototype), "updateState", this).call(this, opts);
      var aggregationDirty = this.state.aggregationDirty;

      if (aggregationDirty) {
        this.setState({
          gridHash: null
        });
      }
    }
  }, {
    key: "getHashKeyForIndex",
    value: function getHashKeyForIndex(index) {
      var _this$state = this.state,
          numRow = _this$state.numRow,
          numCol = _this$state.numCol,
          boundingBox = _this$state.boundingBox,
          gridOffset = _this$state.gridOffset;
      var gridSize = [numCol, numRow];
      var gridOrigin = [boundingBox.xMin, boundingBox.yMin];
      var cellSize = [gridOffset.xOffset, gridOffset.yOffset];
      var yIndex = Math.floor(index / gridSize[0]);
      var xIndex = index - yIndex * gridSize[0];
      var latIdx = Math.floor((yIndex * cellSize[1] + gridOrigin[1] + 90 + cellSize[1] / 2) / cellSize[1]);
      var lonIdx = Math.floor((xIndex * cellSize[0] + gridOrigin[0] + 180 + cellSize[0] / 2) / cellSize[0]);
      return "".concat(latIdx, "-").concat(lonIdx);
    }
  }, {
    key: "getPositionForIndex",
    value: function getPositionForIndex(index) {
      var _this$state2 = this.state,
          numRow = _this$state2.numRow,
          numCol = _this$state2.numCol,
          boundingBox = _this$state2.boundingBox,
          gridOffset = _this$state2.gridOffset;
      var gridSize = [numCol, numRow];
      var gridOrigin = [boundingBox.xMin, boundingBox.yMin];
      var cellSize = [gridOffset.xOffset, gridOffset.yOffset];
      var yIndex = Math.floor(index / gridSize[0]);
      var xIndex = index - yIndex * gridSize[0];
      var yPos = yIndex * cellSize[1] + gridOrigin[1];
      var xPos = xIndex * cellSize[0] + gridOrigin[0];
      return [xPos, yPos];
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref) {
      var info = _ref.info,
          mode = _ref.mode;
      var index = info.index;
      var object = null;

      if (index >= 0) {
        var gpuGridAggregator = this.state.gpuGridAggregator;
        var position = this.getPositionForIndex(index);

        var colorInfo = _gpuGridAggregator["default"].getAggregationData(Object.assign({
          pixelIndex: index
        }, gpuGridAggregator.getData('color')));

        var elevationInfo = _gpuGridAggregator["default"].getAggregationData(Object.assign({
          pixelIndex: index
        }, gpuGridAggregator.getData('elevation')));

        object = {
          colorValue: colorInfo.cellWeight,
          elevationValue: elevationInfo.cellWeight,
          count: colorInfo.cellCount || elevationInfo.cellCount,
          position: position,
          totalCount: colorInfo.totalCount || elevationInfo.totalCount
        };

        if (mode !== 'hover') {
          var props = this.props;
          var gridHash = this.state.gridHash;

          if (!gridHash) {
            var _this$state3 = this.state,
                gridOffset = _this$state3.gridOffset,
                translation = _this$state3.translation,
                boundingBox = _this$state3.boundingBox;
            var viewport = this.context.viewport;
            var attributes = this.getAttributes();
            var cpuAggregation = (0, _gridAggregator.pointToDensityGridDataCPU)(props, {
              gridOffset: gridOffset,
              attributes: attributes,
              viewport: viewport,
              translation: translation,
              boundingBox: boundingBox
            });
            gridHash = cpuAggregation.gridHash;
            this.setState({
              gridHash: gridHash
            });
          }

          var key = this.getHashKeyForIndex(index);
          var cpuAggregationData = gridHash[key];
          Object.assign(object, cpuAggregationData);
        }
      }

      return Object.assign(info, {
        picked: Boolean(object),
        object: object
      });
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      if (!this.state.isSupported) {
        return null;
      }

      var _this$props = this.props,
          elevationScale = _this$props.elevationScale,
          extruded = _this$props.extruded,
          cellSizeMeters = _this$props.cellSize,
          coverage = _this$props.coverage,
          material = _this$props.material,
          elevationRange = _this$props.elevationRange,
          colorDomain = _this$props.colorDomain,
          elevationDomain = _this$props.elevationDomain;
      var _this$state4 = this.state,
          weights = _this$state4.weights,
          numRow = _this$state4.numRow,
          numCol = _this$state4.numCol,
          gridOrigin = _this$state4.gridOrigin,
          gridOffset = _this$state4.gridOffset;
      var color = weights.color,
          elevation = weights.elevation;
      var colorRange = (0, _colorUtils.colorRangeToFlatArray)(this.props.colorRange);
      var SubLayerClass = this.getSubLayerClass('gpu-grid-cell', _gpuGridCellLayer["default"]);
      return new SubLayerClass({
        gridSize: [numCol, numRow],
        gridOrigin: gridOrigin,
        gridOffset: [gridOffset.xOffset, gridOffset.yOffset],
        colorRange: colorRange,
        elevationRange: elevationRange,
        colorDomain: colorDomain,
        elevationDomain: elevationDomain,
        cellSize: cellSizeMeters,
        coverage: coverage,
        material: material,
        elevationScale: elevationScale,
        extruded: extruded
      }, this.getSubLayerProps({
        id: 'gpu-grid-cell'
      }), {
        data: {
          attributes: {
            colors: color.aggregationBuffer,
            elevations: elevation.aggregationBuffer
          }
        },
        colorMaxMinBuffer: color.maxMinBuffer,
        elevationMaxMinBuffer: elevation.maxMinBuffer,
        numInstances: numCol * numRow
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var _this$state$weights = this.state.weights,
          color = _this$state$weights.color,
          elevation = _this$state$weights.elevation;
      [color, elevation].forEach(function (weight) {
        var aggregationBuffer = weight.aggregationBuffer,
            maxMinBuffer = weight.maxMinBuffer;
        maxMinBuffer["delete"]();

        if (aggregationBuffer) {
          aggregationBuffer["delete"]();
        }
      });
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(GPUGridLayer.prototype), "finalizeState", this).call(this);
    }
  }, {
    key: "updateAggregationState",
    value: function updateAggregationState(opts) {
      var props = opts.props,
          oldProps = opts.oldProps;
      var cellSize = props.cellSize,
          coordinateSystem = props.coordinateSystem;
      var viewport = this.context.viewport;
      var cellSizeChanged = oldProps.cellSize !== cellSize;
      var dimensions = this.state.dimensions;
      var positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME);
      var attributesChanged = positionsChanged || this.isAttributeChanged();
      var boundingBox = this.state.boundingBox;

      if (positionsChanged) {
        boundingBox = (0, _gridAggregationUtils.getBoundingBox)(this.getAttributes(), this.getNumInstances());
        this.setState({
          boundingBox: boundingBox
        });
      }

      if (positionsChanged || cellSizeChanged) {
        var _getGridParams = (0, _gridAggregationUtils.getGridParams)(boundingBox, cellSize, viewport, coordinateSystem),
            gridOffset = _getGridParams.gridOffset,
            translation = _getGridParams.translation,
            width = _getGridParams.width,
            height = _getGridParams.height,
            numCol = _getGridParams.numCol,
            numRow = _getGridParams.numRow;

        this.allocateResources(numRow, numCol);
        this.setState({
          gridOffset: gridOffset,
          translation: translation,
          gridOrigin: [-1 * translation[0], -1 * translation[1]],
          width: width,
          height: height,
          numCol: numCol,
          numRow: numRow
        });
      }

      var aggregationDataDirty = attributesChanged || this.isAggregationDirty(opts, {
        dimension: dimensions.data,
        compareAll: true
      });

      if (aggregationDataDirty) {
        this._updateAccessors(opts);
      }

      this.setState({
        aggregationDataDirty: aggregationDataDirty
      });
    }
  }, {
    key: "_updateAccessors",
    value: function _updateAccessors(opts) {
      var _opts$props = opts.props,
          colorAggregation = _opts$props.colorAggregation,
          elevationAggregation = _opts$props.elevationAggregation;
      var _this$state$weights2 = this.state.weights,
          color = _this$state$weights2.color,
          elevation = _this$state$weights2.elevation;
      color.operation = _aggregationOperationUtils.AGGREGATION_OPERATION[colorAggregation];
      elevation.operation = _aggregationOperationUtils.AGGREGATION_OPERATION[elevationAggregation];
    }
  }]);
  return GPUGridLayer;
}(_gridAggregationLayer["default"]);

exports["default"] = GPUGridLayer;
GPUGridLayer.layerName = 'GPUGridLayer';
GPUGridLayer.defaultProps = defaultProps;
//# sourceMappingURL=gpu-grid-layer.js.map