"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBounds = getBounds;
exports.boundsContain = boundsContain;
exports.packVertices = packVertices;
exports.scaleToAspectRatio = scaleToAspectRatio;
exports.getTextureCoordinates = getTextureCoordinates;
exports.getTextureParams = getTextureParams;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _core = require("@luma.gl/core");

function getBounds(points) {
  var x = points.map(function (p) {
    return p[0];
  });
  var y = points.map(function (p) {
    return p[1];
  });
  var xMin = Math.min.apply(null, x);
  var xMax = Math.max.apply(null, x);
  var yMin = Math.min.apply(null, y);
  var yMax = Math.max.apply(null, y);
  return [xMin, yMin, xMax, yMax];
}

function boundsContain(currentBounds, targetBounds) {
  if (targetBounds[0] >= currentBounds[0] && targetBounds[2] <= currentBounds[2] && targetBounds[1] >= currentBounds[1] && targetBounds[3] <= currentBounds[3]) {
    return true;
  }

  return false;
}

var scratchArray = new Float32Array(12);

function packVertices(points) {
  var dimensions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var index = 0;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = points[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var point = _step.value;

      for (var i = 0; i < dimensions; i++) {
        scratchArray[index++] = point[i] || 0;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return scratchArray;
}

function scaleToAspectRatio(boundingBox, width, height) {
  var _boundingBox = (0, _slicedToArray2["default"])(boundingBox, 4),
      xMin = _boundingBox[0],
      yMin = _boundingBox[1],
      xMax = _boundingBox[2],
      yMax = _boundingBox[3];

  var currentWidth = xMax - xMin;
  var currentHeight = yMax - yMin;
  var newWidth = currentWidth;
  var newHeight = currentHeight;

  if (currentWidth / currentHeight < width / height) {
    newWidth = width / height * currentHeight;
  } else {
    newHeight = height / width * currentWidth;
  }

  if (newWidth < width) {
    newWidth = width;
    newHeight = height;
  }

  var xCenter = (xMax + xMin) / 2;
  var yCenter = (yMax + yMin) / 2;
  return [xCenter - newWidth / 2, yCenter - newHeight / 2, xCenter + newWidth / 2, yCenter + newHeight / 2];
}

function getTextureCoordinates(point, bounds) {
  var _bounds = (0, _slicedToArray2["default"])(bounds, 4),
      xMin = _bounds[0],
      yMin = _bounds[1],
      xMax = _bounds[2],
      yMax = _bounds[3];

  return [(point[0] - xMin) / (xMax - xMin), (point[1] - yMin) / (yMax - yMin)];
}

function getTextureParams(_ref) {
  var gl = _ref.gl,
      floatTargetSupport = _ref.floatTargetSupport;
  return {
    format: (0, _core.isWebGL2)(gl) ? 34836 : 6408,
    type: floatTargetSupport ? 5126 : 5121
  };
}
//# sourceMappingURL=heatmap-layer-utils.js.map