"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = "#define SHADER_NAME heatp-map-layer-vertex-shader\n\nuniform sampler2D maxTexture;\nuniform float intensity;\nuniform vec2 colorDomain;\nuniform float threshold;\n\nattribute vec3 positions;\nattribute vec2 texCoords;\n\nvarying vec2 vTexCoords;\nvarying float vIntensityMin;\nvarying float vIntensityMax;\n\nvoid main(void) {\n  gl_Position = project_position_to_clipspace(positions, vec3(0.0), vec3(0.0));\n  vTexCoords = texCoords;\n  float maxValue = texture2D(maxTexture, vec2(0.5)).r;\n  float minValue = maxValue * threshold;\n  if (colorDomain[1] > 0.) {\n    maxValue = colorDomain[1];\n    minValue = colorDomain[0];\n  }\n  vIntensityMax = intensity / maxValue;\n  vIntensityMin = intensity / minValue;\n}\n";
exports["default"] = _default;
//# sourceMappingURL=triangle-layer-vertex.glsl.js.map