"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _layers = require("@deck.gl/layers");

var _colorUtils = require("../utils/color-utils");

var _hexagonAggregator = require("./hexagon-aggregator");

var _cpuAggregator = _interopRequireDefault(require("../utils/cpu-aggregator"));

var _aggregationLayer = _interopRequireDefault(require("../aggregation-layer"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function nop() {}

var defaultProps = {
  colorDomain: null,
  colorRange: _colorUtils.defaultColorRange,
  getColorValue: {
    type: 'accessor',
    value: null
  },
  getColorWeight: {
    type: 'accessor',
    value: function value(x) {
      return 1;
    }
  },
  colorAggregation: 'SUM',
  lowerPercentile: {
    type: 'number',
    value: 0,
    min: 0,
    max: 100
  },
  upperPercentile: {
    type: 'number',
    value: 100,
    min: 0,
    max: 100
  },
  colorScaleType: 'quantize',
  onSetColorDomain: nop,
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationValue: {
    type: 'accessor',
    value: null
  },
  getElevationWeight: {
    type: 'accessor',
    value: function value(x) {
      return 1;
    }
  },
  elevationAggregation: 'SUM',
  elevationLowerPercentile: {
    type: 'number',
    value: 0,
    min: 0,
    max: 100
  },
  elevationUpperPercentile: {
    type: 'number',
    value: 100,
    min: 0,
    max: 100
  },
  elevationScale: {
    type: 'number',
    min: 0,
    value: 1
  },
  elevationScaleType: 'linear',
  onSetElevationDomain: nop,
  radius: {
    type: 'number',
    value: 1000,
    min: 1
  },
  coverage: {
    type: 'number',
    min: 0,
    max: 1,
    value: 1
  },
  extruded: false,
  hexagonAggregator: _hexagonAggregator.pointToHexbin,
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  material: true,
  _filterData: {
    type: 'function',
    value: null,
    optional: true
  }
};

var HexagonLayer = function (_AggregationLayer) {
  (0, _inherits2["default"])(HexagonLayer, _AggregationLayer);

  function HexagonLayer() {
    (0, _classCallCheck2["default"])(this, HexagonLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(HexagonLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(HexagonLayer, [{
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var cpuAggregator = new _cpuAggregator["default"]({
        getAggregator: function getAggregator(props) {
          return props.hexagonAggregator;
        },
        getCellSize: function getCellSize(props) {
          return props.radius;
        }
      });
      this.state = {
        cpuAggregator: cpuAggregator,
        aggregatorState: cpuAggregator.state,
        hexagonVertices: null
      };
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          accessor: 'getPosition'
        }
      });
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(HexagonLayer.prototype), "updateState", this).call(this, opts);
      var _this$state = this.state,
          cpuAggregator = _this$state.cpuAggregator,
          oldVertices = _this$state.hexagonVertices;

      if (opts.changeFlags.propsOrDataChanged) {
        this.setState({
          aggregatorState: cpuAggregator.updateState(opts, {
            viewport: this.context.viewport,
            attributes: this.getAttributes()
          })
        });
      }

      var _ref2 = cpuAggregator.state.layerData || {},
          hexagonVertices = _ref2.hexagonVertices;

      if (hexagonVertices && oldVertices !== hexagonVertices) {
        var vertices = this.convertLatLngToMeterOffset(hexagonVertices);

        if (vertices) {
          this.setState({
            hexagonVertices: hexagonVertices,
            vertices: vertices
          });
        }
      } else {
        this.updateRadiusAngle();
      }
    }
  }, {
    key: "updateRadiusAngle",
    value: function updateRadiusAngle(vertices) {
      var viewport = this.context.viewport;

      var _viewport$getDistance = viewport.getDistanceScales(),
          unitsPerMeter = _viewport$getDistance.unitsPerMeter;

      var cpuAggregator = this.state.cpuAggregator;

      if (cpuAggregator.state.layerData && cpuAggregator.state.layerData.radiusCommon) {
        var radiusCommon = cpuAggregator.state.layerData.radiusCommon;
        var radius = radiusCommon / unitsPerMeter[0];
        this.setState({
          angle: 90,
          radius: radius
        });
      }
    }
  }, {
    key: "convertLatLngToMeterOffset",
    value: function convertLatLngToMeterOffset(hexagonVertices) {
      var viewport = this.context.viewport;

      if (Array.isArray(hexagonVertices) && hexagonVertices.length === 6) {
        var vertex0 = hexagonVertices[0];
        var vertex3 = hexagonVertices[3];
        var centroid = [(vertex0[0] + vertex3[0]) / 2, (vertex0[1] + vertex3[1]) / 2];
        var centroidFlat = viewport.projectFlat(centroid);

        var _viewport$getDistance2 = viewport.getDistanceScales(centroid),
            metersPerUnit = _viewport$getDistance2.metersPerUnit;

        var vertices = hexagonVertices.map(function (vt) {
          var vtFlat = viewport.projectFlat(vt);
          return [(vtFlat[0] - centroidFlat[0]) * metersPerUnit[0], (vtFlat[1] - centroidFlat[1]) * metersPerUnit[1]];
        });
        return vertices;
      }

      _core.log.error('HexagonLayer: hexagonVertices needs to be an array of 6 points')();

      return null;
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref3) {
      var info = _ref3.info;
      return this.state.cpuAggregator.getPickingInfo({
        info: info
      });
    }
  }, {
    key: "_onGetSublayerColor",
    value: function _onGetSublayerColor(cell) {
      return this.state.cpuAggregator.getAccessor('fillColor')(cell);
    }
  }, {
    key: "_onGetSublayerElevation",
    value: function _onGetSublayerElevation(cell) {
      return this.state.cpuAggregator.getAccessor('elevation')(cell);
    }
  }, {
    key: "_getSublayerUpdateTriggers",
    value: function _getSublayerUpdateTriggers() {
      return this.state.cpuAggregator.getUpdateTriggers(this.props);
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$props = this.props,
          elevationScale = _this$props.elevationScale,
          extruded = _this$props.extruded,
          coverage = _this$props.coverage,
          material = _this$props.material,
          transitions = _this$props.transitions;
      var _this$state2 = this.state,
          angle = _this$state2.angle,
          radius = _this$state2.radius,
          cpuAggregator = _this$state2.cpuAggregator,
          vertices = _this$state2.vertices;
      var SubLayerClass = this.getSubLayerClass('hexagon-cell', _layers.ColumnLayer);

      var updateTriggers = this._getSublayerUpdateTriggers();

      var geometry = vertices && vertices.length ? {
        vertices: vertices,
        radius: 1
      } : {
        radius: radius,
        angle: angle
      };
      return new SubLayerClass(_objectSpread({}, geometry, {
        diskResolution: 6,
        elevationScale: elevationScale,
        extruded: extruded,
        coverage: coverage,
        material: material,
        getFillColor: this._onGetSublayerColor.bind(this),
        getElevation: this._onGetSublayerElevation.bind(this),
        transitions: transitions && {
          getFillColor: transitions.getColorValue || transitions.getColorWeight,
          getElevation: transitions.getElevationValue || transitions.getElevationWeight
        }
      }), this.getSubLayerProps({
        id: 'hexagon-cell',
        updateTriggers: updateTriggers
      }), {
        data: cpuAggregator.state.layerData.data
      });
    }
  }]);
  return HexagonLayer;
}(_aggregationLayer["default"]);

exports["default"] = HexagonLayer;
HexagonLayer.layerName = 'HexagonLayer';
HexagonLayer.defaultProps = defaultProps;
//# sourceMappingURL=hexagon-layer.js.map