"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _gpuGridAggregator = _interopRequireDefault(require("../utils/gpu-grid-aggregation/gpu-grid-aggregator"));

var _aggregationOperationUtils = require("../utils/aggregation-operation-utils");

var _screenGridCellLayer = _interopRequireDefault(require("./screen-grid-cell-layer"));

var _gridAggregationLayer = _interopRequireDefault(require("../grid-aggregation-layer"));

var _resourceUtils = require("../utils/resource-utils.js");

var defaultProps = Object.assign({}, _screenGridCellLayer["default"].defaultProps, {
  getPosition: {
    type: 'accessor',
    value: function value(d) {
      return d.position;
    }
  },
  getWeight: {
    type: 'accessor',
    value: function value(d) {
      return 1;
    }
  },
  gpuAggregation: true,
  aggregation: 'SUM'
});
var POSITION_ATTRIBUTE_NAME = 'positions';
var DIMENSIONS = {
  data: {
    props: ['cellSizePixels']
  },
  weights: {
    props: ['aggregation'],
    accessors: ['getWeight']
  }
};

var ScreenGridLayer = function (_GridAggregationLayer) {
  (0, _inherits2["default"])(ScreenGridLayer, _GridAggregationLayer);

  function ScreenGridLayer() {
    (0, _classCallCheck2["default"])(this, ScreenGridLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(ScreenGridLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(ScreenGridLayer, [{
    key: "initializeState",
    value: function initializeState() {
      var _attributeManager$add;

      var gl = this.context.gl;

      if (!_screenGridCellLayer["default"].isSupported(gl)) {
        this.setState({
          supported: false
        });

        _core.log.error("ScreenGridLayer: ".concat(this.id, " is not supported on this browser"))();

        return;
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(ScreenGridLayer.prototype), "initializeState", this).call(this, {
        dimensions: DIMENSIONS,
        getCellSize: function getCellSize(props) {
          return props.cellSizePixels;
        }
      });
      var weights = {
        count: {
          size: 1,
          operation: _aggregationOperationUtils.AGGREGATION_OPERATION.SUM,
          needMax: true,
          maxTexture: (0, _resourceUtils.getFloatTexture)(gl, {
            id: "".concat(this.id, "-max-texture")
          })
        }
      };
      this.setState({
        supported: true,
        projectPoints: true,
        weights: weights,
        subLayerData: {
          attributes: {}
        },
        maxTexture: weights.count.maxTexture,
        positionAttributeName: 'positions',
        posOffset: [0, 0],
        translation: [1, -1]
      });
      var attributeManager = this.getAttributeManager();
      attributeManager.add((_attributeManager$add = {}, (0, _defineProperty2["default"])(_attributeManager$add, POSITION_ATTRIBUTE_NAME, {
        size: 3,
        accessor: 'getPosition',
        type: 5130,
        fp64: this.use64bitPositions()
      }), (0, _defineProperty2["default"])(_attributeManager$add, "count", {
        size: 3,
        accessor: 'getWeight'
      }), _attributeManager$add));
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return this.state.supported && changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(ScreenGridLayer.prototype), "updateState", this).call(this, opts);
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      if (!this.state.supported) {
        return [];
      }

      var _this$state = this.state,
          maxTexture = _this$state.maxTexture,
          numRow = _this$state.numRow,
          numCol = _this$state.numCol,
          weights = _this$state.weights;
      var updateTriggers = this.props.updateTriggers;
      var aggregationBuffer = weights.count.aggregationBuffer;
      var CellLayerClass = this.getSubLayerClass('cells', _screenGridCellLayer["default"]);
      return new CellLayerClass(this.props, this.getSubLayerProps({
        id: 'cell-layer',
        updateTriggers: updateTriggers
      }), {
        data: {
          attributes: {
            instanceCounts: aggregationBuffer
          }
        },
        maxTexture: maxTexture,
        numInstances: numRow * numCol
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(ScreenGridLayer.prototype), "finalizeState", this).call(this);
      var _this$state2 = this.state,
          aggregationBuffer = _this$state2.aggregationBuffer,
          maxBuffer = _this$state2.maxBuffer,
          maxTexture = _this$state2.maxTexture;

      if (aggregationBuffer) {
        aggregationBuffer["delete"]();
      }

      if (maxBuffer) {
        maxBuffer["delete"]();
      }

      if (maxTexture) {
        maxTexture["delete"]();
      }
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info,
          mode = _ref2.mode;
      var index = info.index;

      if (index >= 0) {
        var gpuGridAggregator = this.state.gpuGridAggregator;
        var aggregationResults = gpuGridAggregator.getData('count');
        info.object = _gpuGridAggregator["default"].getAggregationData(Object.assign({
          pixelIndex: index
        }, aggregationResults));
      }

      return info;
    }
  }, {
    key: "updateResults",
    value: function updateResults(_ref3) {
      var aggregationData = _ref3.aggregationData,
          maxData = _ref3.maxData;
      var count = this.state.weights.count;
      count.aggregationData = aggregationData;
      count.aggregationBuffer.setData({
        data: aggregationData
      });
      count.maxData = maxData;
      count.maxTexture.setImageData({
        data: maxData
      });
    }
  }, {
    key: "updateAggregationState",
    value: function updateAggregationState(opts) {
      var cellSize = opts.props.cellSizePixels;
      var cellSizeChanged = opts.oldProps.cellSizePixels !== cellSize;
      var viewportChanged = opts.changeFlags.viewportChanged;
      var gpuAggregation = opts.props.gpuAggregation;

      if (this.state.gpuAggregation !== opts.props.gpuAggregation) {
        if (gpuAggregation && !_gpuGridAggregator["default"].isSupported(this.context.gl)) {
          _core.log.warn('GPU Grid Aggregation not supported, falling back to CPU')();

          gpuAggregation = false;
        }
      }

      var gpuAggregationChanged = gpuAggregation !== this.state.gpuAggregation;
      this.setState({
        gpuAggregation: gpuAggregation
      });
      var positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME);
      var dimensions = this.state.dimensions;
      var data = dimensions.data,
          weights = dimensions.weights;
      var aggregationDataDirty = positionsChanged || gpuAggregationChanged || viewportChanged || this.isAggregationDirty(opts, {
        compareAll: gpuAggregation,
        dimension: data
      });
      var aggregationWeightsDirty = this.isAggregationDirty(opts, {
        dimension: weights
      });
      this.setState({
        aggregationDataDirty: aggregationDataDirty,
        aggregationWeightsDirty: aggregationWeightsDirty
      });
      var viewport = this.context.viewport;

      if (viewportChanged || cellSizeChanged) {
        var width = viewport.width,
            height = viewport.height;
        var numCol = Math.ceil(width / cellSize);
        var numRow = Math.ceil(height / cellSize);
        this.allocateResources(numRow, numCol);
        this.setState({
          scaling: [width / 2, -height / 2, 1],
          gridOffset: {
            xOffset: cellSize,
            yOffset: cellSize
          },
          width: width,
          height: height,
          numCol: numCol,
          numRow: numRow
        });
      }

      if (aggregationWeightsDirty) {
        this._updateAccessors(opts);
      }

      if (aggregationDataDirty || aggregationWeightsDirty) {
        this._resetResults();
      }
    }
  }, {
    key: "_updateAccessors",
    value: function _updateAccessors(opts) {
      var _opts$props = opts.props,
          getWeight = _opts$props.getWeight,
          aggregation = _opts$props.aggregation;
      var count = this.state.weights.count;

      if (count) {
        count.getWeight = getWeight;
        count.operation = _aggregationOperationUtils.AGGREGATION_OPERATION[aggregation];
      }

      this.setState({
        getValue: (0, _aggregationOperationUtils.getValueFunc)(aggregation, getWeight)
      });
    }
  }, {
    key: "_resetResults",
    value: function _resetResults() {
      var count = this.state.weights.count;

      if (count) {
        count.aggregationData = null;
      }
    }
  }]);
  return ScreenGridLayer;
}(_gridAggregationLayer["default"]);

exports["default"] = ScreenGridLayer;
ScreenGridLayer.layerName = 'ScreenGridLayer';
ScreenGridLayer.defaultProps = defaultProps;
//# sourceMappingURL=screen-grid-layer.js.map