import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { Model, Geometry } from '@luma.gl/core';
import { Layer, project32 } from '@deck.gl/core';
import vs from './triangle-layer-vertex.glsl';
import fs from './triangle-layer-fragment.glsl';
const defaultProps = {
  count: 0,
  texture: null
};
export default class TriangleLayer extends Layer {
  getShaders() {
    return {
      vs,
      fs,
      modules: [project32]
    };
  }

  initializeState() {
    const {
      gl
    } = this.context;
    const attributeManager = this.getAttributeManager();
    attributeManager.add({
      positions: {
        size: 3,
        noAlloc: true
      },
      texCoords: {
        size: 2,
        noAlloc: true
      }
    });
    this.setState({
      model: this._getModel(gl)
    });
  }

  _getModel(gl) {
    const {
      vertexCount
    } = this.props;
    return new Model(gl, Object.assign({}, this.getShaders(), {
      id: this.props.id,
      geometry: new Geometry({
        drawMode: 6,
        vertexCount
      })
    }));
  }

  draw({
    uniforms
  }) {
    const {
      model
    } = this.state;
    const {
      texture,
      maxTexture,
      colorTexture,
      intensity,
      threshold,
      colorDomain
    } = this.props;
    model.setUniforms(_objectSpread({}, uniforms, {
      texture,
      maxTexture,
      colorTexture,
      intensity,
      threshold,
      colorDomain
    })).draw();
  }

}
TriangleLayer.layerName = 'TriangleLayer';
TriangleLayer.defaultProps = defaultProps;
//# sourceMappingURL=triangle-layer.js.map