import { getCode, getVertices, CONTOUR_TYPE } from './marching-squares';
export function generateContours(_ref) {
  var thresholdData = _ref.thresholdData,
      colors = _ref.colors,
      cellWeights = _ref.cellWeights,
      gridSize = _ref.gridSize,
      gridOrigin = _ref.gridOrigin,
      cellSize = _ref.cellSize;
  var contourSegments = [];
  var contourPolygons = [];
  var width = gridSize[0];
  var height = gridSize[1];
  var segmentIndex = 0;
  var polygonIndex = 0;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = thresholdData[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var data = _step.value;
      var contour = data.contour;
      var threshold = contour.threshold;

      for (var x = -1; x < width; x++) {
        for (var y = -1; y < height; y++) {
          var _getCode = getCode({
            cellWeights: cellWeights,
            threshold: threshold,
            x: x,
            y: y,
            width: width,
            height: height
          }),
              code = _getCode.code,
              meanCode = _getCode.meanCode;

          var opts = {
            gridOrigin: gridOrigin,
            cellSize: cellSize,
            x: x,
            y: y,
            width: width,
            height: height,
            code: code,
            meanCode: meanCode,
            thresholdData: data
          };

          if (Array.isArray(threshold)) {
            opts.type = CONTOUR_TYPE.ISO_BANDS;
            var polygons = getVertices(opts);
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
              for (var _iterator2 = polygons[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                var polygon = _step2.value;
                contourPolygons[polygonIndex++] = {
                  vertices: polygon,
                  contour: contour
                };
              }
            } catch (err) {
              _didIteratorError2 = true;
              _iteratorError2 = err;
            } finally {
              try {
                if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
                  _iterator2["return"]();
                }
              } finally {
                if (_didIteratorError2) {
                  throw _iteratorError2;
                }
              }
            }
          } else {
            opts.type = CONTOUR_TYPE.ISO_LINES;
            var vertices = getVertices(opts);

            for (var i = 0; i < vertices.length; i += 2) {
              contourSegments[segmentIndex++] = {
                start: vertices[i],
                end: vertices[i + 1],
                contour: contour
              };
            }
          }
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return {
    contourSegments: contourSegments,
    contourPolygons: contourPolygons
  };
}
//# sourceMappingURL=contour-utils.js.map