import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _parameters;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { getBounds, boundsContain, packVertices, scaleToAspectRatio, getTextureCoordinates, getTextureParams } from './heatmap-layer-utils';
import { Buffer, Texture2D, Transform, getParameters, FEATURES, hasFeatures, isWebGL2 } from '@luma.gl/core';
import { AttributeManager, COORDINATE_SYSTEM, log, _mergeShaders as mergeShaders, project32 } from '@deck.gl/core';
import TriangleLayer from './triangle-layer';
import AggregationLayer from '../aggregation-layer';
import { defaultColorRange, colorRangeToFlatArray } from '../utils/color-utils';
import weights_vs from './weights-vs.glsl';
import weights_fs from './weights-fs.glsl';
import vs_max from './max-vs.glsl';
var RESOLUTION = 2;
var SIZE_2K = 2048;
var ZOOM_DEBOUNCE = 500;
var TEXTURE_OPTIONS = {
  mipmaps: false,
  parameters: (_parameters = {}, _defineProperty(_parameters, 10240, 9729), _defineProperty(_parameters, 10241, 9729), _defineProperty(_parameters, 10242, 33071), _defineProperty(_parameters, 10243, 33071), _parameters),
  dataFormat: 6408
};
var DEFAULT_COLOR_DOMAIN = [0, 0];
var defaultProps = {
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getWeight: {
    type: 'accessor',
    value: 1
  },
  intensity: {
    type: 'number',
    min: 0,
    value: 1
  },
  radiusPixels: {
    type: 'number',
    min: 1,
    max: 100,
    value: 50
  },
  colorRange: defaultColorRange,
  threshold: {
    type: 'number',
    min: 0,
    max: 1,
    value: 0.05
  },
  colorDomain: {
    type: 'array',
    value: null,
    optional: true
  }
};
var REQUIRED_FEATURES = [FEATURES.BLEND_EQUATION_MINMAX, FEATURES.TEXTURE_FLOAT];
var DIMENSIONS = {
  data: {
    props: ['radiusPixels']
  }
};

var HeatmapLayer = function (_AggregationLayer) {
  _inherits(HeatmapLayer, _AggregationLayer);

  function HeatmapLayer() {
    _classCallCheck(this, HeatmapLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(HeatmapLayer).apply(this, arguments));
  }

  _createClass(HeatmapLayer, [{
    key: "initializeState",
    value: function initializeState() {
      var gl = this.context.gl;

      if (!hasFeatures(gl, REQUIRED_FEATURES)) {
        this.setState({
          supported: false
        });
        log.error("HeatmapLayer: ".concat(this.id, " is not supported on this browser"))();
        return;
      }

      _get(_getPrototypeOf(HeatmapLayer.prototype), "initializeState", this).call(this, DIMENSIONS);

      this.setState({
        supported: true
      });

      this._setupTextureParams();

      this._setupAttributes();

      this._setupResources();
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(opts) {
      if (!this.state.supported) {
        return;
      }

      _get(_getPrototypeOf(HeatmapLayer.prototype), "updateState", this).call(this, opts);

      var props = opts.props,
          oldProps = opts.oldProps;

      var changeFlags = this._getChangeFlags(opts);

      if (changeFlags.viewportChanged) {
        changeFlags.boundsChanged = this._updateBounds();
      }

      if (changeFlags.dataChanged || changeFlags.boundsChanged) {
        this._updateWeightmap();
      } else if (changeFlags.viewportZoomChanged) {
        this._debouncedUpdateWeightmap();
      }

      if (props.colorRange !== oldProps.colorRange) {
        this._updateColorTexture(opts);
      }

      if (changeFlags.viewportChanged) {
        this._updateTextureRenderingBounds();
      }

      if (oldProps.colorDomain !== props.colorDomain || changeFlags.viewportChanged) {
        var viewport = this.context.viewport;
        var weightsScale = this.state.weightsScale;
        var domainScale = (viewport ? 1024 / viewport.scale : 1) * weightsScale;
        var colorDomain = props.colorDomain ? props.colorDomain.map(function (x) {
          return x * domainScale;
        }) : DEFAULT_COLOR_DOMAIN;

        if (colorDomain[1] > 0 && weightsScale < 1) {
          var max = Math.min(colorDomain[1], 1);
          colorDomain[0] *= max / colorDomain[1];
          colorDomain[1] = max;
        }

        this.setState({
          colorDomain: colorDomain
        });
      }

      this.setState({
        zoom: opts.context.viewport.zoom
      });
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      if (!this.state.supported) {
        return [];
      }

      var _this$state = this.state,
          weightsTexture = _this$state.weightsTexture,
          triPositionBuffer = _this$state.triPositionBuffer,
          triTexCoordBuffer = _this$state.triTexCoordBuffer,
          maxWeightsTexture = _this$state.maxWeightsTexture,
          colorTexture = _this$state.colorTexture,
          colorDomain = _this$state.colorDomain;
      var _this$props = this.props,
          updateTriggers = _this$props.updateTriggers,
          intensity = _this$props.intensity,
          threshold = _this$props.threshold;
      var TriangleLayerClass = this.getSubLayerClass('triangle', TriangleLayer);
      return new TriangleLayerClass(this.getSubLayerProps({
        id: 'triangle-layer',
        updateTriggers: updateTriggers
      }), {
        data: {
          attributes: {
            positions: triPositionBuffer,
            texCoords: triTexCoordBuffer
          }
        },
        vertexCount: 4,
        maxTexture: maxWeightsTexture,
        colorTexture: colorTexture,
        texture: weightsTexture,
        intensity: intensity,
        threshold: threshold,
        colorDomain: colorDomain
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      _get(_getPrototypeOf(HeatmapLayer.prototype), "finalizeState", this).call(this);

      var _this$state2 = this.state,
          weightsTransform = _this$state2.weightsTransform,
          weightsTexture = _this$state2.weightsTexture,
          maxWeightTransform = _this$state2.maxWeightTransform,
          maxWeightsTexture = _this$state2.maxWeightsTexture,
          triPositionBuffer = _this$state2.triPositionBuffer,
          triTexCoordBuffer = _this$state2.triTexCoordBuffer,
          colorTexture = _this$state2.colorTexture,
          updateTimer = _this$state2.updateTimer;
      weightsTransform && weightsTransform["delete"]();
      weightsTexture && weightsTexture["delete"]();
      maxWeightTransform && maxWeightTransform["delete"]();
      maxWeightsTexture && maxWeightsTexture["delete"]();
      triPositionBuffer && triPositionBuffer["delete"]();
      triTexCoordBuffer && triTexCoordBuffer["delete"]();
      colorTexture && colorTexture["delete"]();
      updateTimer && clearTimeout(updateTimer);
    }
  }, {
    key: "_getAttributeManager",
    value: function _getAttributeManager() {
      return new AttributeManager(this.context.gl, {
        id: this.props.id,
        stats: this.context.stats
      });
    }
  }, {
    key: "_getChangeFlags",
    value: function _getChangeFlags(opts) {
      var changeFlags = {};
      var dimensions = this.state.dimensions;
      changeFlags.dataChanged = this.isAttributeChanged() || this.isAggregationDirty(opts, {
        compareAll: true,
        dimension: dimensions.data
      });
      changeFlags.viewportChanged = opts.changeFlags.viewportChanged;
      var zoom = this.state.zoom;

      if (!opts.context.viewport || opts.context.viewport.zoom !== zoom) {
        changeFlags.viewportZoomChanged = true;
      }

      return changeFlags;
    }
  }, {
    key: "_createTextures",
    value: function _createTextures() {
      var gl = this.context.gl;
      var _this$state3 = this.state,
          textureSize = _this$state3.textureSize,
          format = _this$state3.format,
          type = _this$state3.type;
      this.setState({
        weightsTexture: new Texture2D(gl, _objectSpread({
          width: textureSize,
          height: textureSize,
          format: format,
          type: type
        }, TEXTURE_OPTIONS)),
        maxWeightsTexture: new Texture2D(gl, _objectSpread({
          format: format,
          type: type
        }, TEXTURE_OPTIONS))
      });
    }
  }, {
    key: "_setupAttributes",
    value: function _setupAttributes() {
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          accessor: 'getPosition'
        },
        weights: {
          size: 1,
          accessor: 'getWeight'
        }
      });
      this.setState({
        positionAttributeName: 'positions'
      });
    }
  }, {
    key: "_setupTextureParams",
    value: function _setupTextureParams() {
      var gl = this.context.gl;
      var textureSize = Math.min(SIZE_2K, getParameters(gl, 3379));
      var floatTargetSupport = hasFeatures(gl, FEATURES.COLOR_ATTACHMENT_RGBA32F);

      var _getTextureParams = getTextureParams({
        gl: gl,
        floatTargetSupport: floatTargetSupport
      }),
          format = _getTextureParams.format,
          type = _getTextureParams.type;

      var weightsScale = floatTargetSupport ? 1 : 1 / 255;
      this.setState({
        textureSize: textureSize,
        format: format,
        type: type,
        weightsScale: weightsScale
      });

      if (!floatTargetSupport) {
        log.warn("HeatmapLayer: ".concat(this.id, " rendering to float texture not supported, fallingback to low precession format"))();
      }
    }
  }, {
    key: "_createWeightsTransform",
    value: function _createWeightsTransform() {
      var shaderOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var gl = this.context.gl;
      var weightsTransform = this.state.weightsTransform;
      var weightsTexture = this.state.weightsTexture;

      if (weightsTransform) {
        weightsTransform["delete"]();
      }

      var shaders = mergeShaders({
        vs: weights_vs,
        _fs: weights_fs,
        modules: [project32]
      }, shaderOptions);
      weightsTransform = new Transform(gl, _objectSpread({
        id: "".concat(this.id, "-weights-transform"),
        elementCount: 1,
        _targetTexture: weightsTexture,
        _targetTextureVarying: 'weightsTexture'
      }, shaders));
      this.setState({
        weightsTransform: weightsTransform
      });
    }
  }, {
    key: "_setupResources",
    value: function _setupResources() {
      var gl = this.context.gl;

      this._createTextures();

      var _this$state4 = this.state,
          textureSize = _this$state4.textureSize,
          weightsTexture = _this$state4.weightsTexture,
          maxWeightsTexture = _this$state4.maxWeightsTexture;

      this._createWeightsTransform();

      var maxWeightTransform = new Transform(gl, {
        id: "".concat(this.id, "-max-weights-transform"),
        _sourceTextures: {
          inTexture: weightsTexture
        },
        _targetTexture: maxWeightsTexture,
        _targetTextureVarying: 'outTexture',
        vs: vs_max,
        elementCount: textureSize * textureSize
      });
      this.setState({
        weightsTexture: weightsTexture,
        maxWeightsTexture: maxWeightsTexture,
        maxWeightTransform: maxWeightTransform,
        zoom: null,
        triPositionBuffer: new Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 3
          }
        }),
        triTexCoordBuffer: new Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 2
          }
        })
      });
    }
  }, {
    key: "updateShaders",
    value: function updateShaders(shaderOptions) {
      this._createWeightsTransform(shaderOptions);
    }
  }, {
    key: "_updateMaxWeightValue",
    value: function _updateMaxWeightValue() {
      var maxWeightTransform = this.state.maxWeightTransform;
      maxWeightTransform.run({
        parameters: {
          blend: true,
          depthTest: false,
          blendFunc: [1, 1],
          blendEquation: 32776
        }
      });
    }
  }, {
    key: "_updateBounds",
    value: function _updateBounds() {
      var forceUpdate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var viewport = this.context.viewport;
      var viewportCorners = [viewport.unproject([0, 0]), viewport.unproject([viewport.width, 0]), viewport.unproject([viewport.width, viewport.height]), viewport.unproject([0, viewport.height])];
      var visibleWorldBounds = getBounds(viewportCorners);
      var newState = {
        visibleWorldBounds: visibleWorldBounds,
        viewportCorners: viewportCorners
      };
      var boundsChanged = false;

      if (forceUpdate || !this.state.worldBounds || !boundsContain(this.state.worldBounds, visibleWorldBounds)) {
        var scaledCommonBounds = this._worldToCommonBounds(visibleWorldBounds);

        var worldBounds = this._commonToWorldBounds(scaledCommonBounds);

        if (this.props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          worldBounds[1] = Math.max(worldBounds[1], -85.051129);
          worldBounds[3] = Math.min(worldBounds[3], 85.051129);
          worldBounds[0] = Math.max(worldBounds[0], -360);
          worldBounds[2] = Math.min(worldBounds[2], 360);
        }

        var normalizedCommonBounds = this._worldToCommonBounds(worldBounds);

        newState.worldBounds = worldBounds;
        newState.normalizedCommonBounds = normalizedCommonBounds;
        boundsChanged = true;
      }

      this.setState(newState);
      return boundsChanged;
    }
  }, {
    key: "_updateTextureRenderingBounds",
    value: function _updateTextureRenderingBounds() {
      var _this$state5 = this.state,
          triPositionBuffer = _this$state5.triPositionBuffer,
          triTexCoordBuffer = _this$state5.triTexCoordBuffer,
          normalizedCommonBounds = _this$state5.normalizedCommonBounds,
          viewportCorners = _this$state5.viewportCorners;
      var viewport = this.context.viewport;
      triPositionBuffer.subData(packVertices(viewportCorners, 3));
      var textureBounds = viewportCorners.map(function (p) {
        return getTextureCoordinates(viewport.projectPosition(p), normalizedCommonBounds);
      });
      triTexCoordBuffer.subData(packVertices(textureBounds, 2));
    }
  }, {
    key: "_updateColorTexture",
    value: function _updateColorTexture(opts) {
      var colorRange = opts.props.colorRange;
      var colorTexture = this.state.colorTexture;
      var colors = colorRangeToFlatArray(colorRange, true);

      if (colorTexture) {
        colorTexture.setImageData({
          data: colors,
          width: colorRange.length
        });
      } else {
        colorTexture = new Texture2D(this.context.gl, _objectSpread({
          data: colors,
          width: colorRange.length,
          height: 1,
          format: isWebGL2(this.context.gl) ? 34836 : 6408,
          type: 5126
        }, TEXTURE_OPTIONS));
      }

      this.setState({
        colorTexture: colorTexture
      });
    }
  }, {
    key: "_updateWeightmap",
    value: function _updateWeightmap() {
      var _weightsTexture$setPa;

      var radiusPixels = this.props.radiusPixels;
      var _this$state6 = this.state,
          weightsTransform = _this$state6.weightsTransform,
          worldBounds = _this$state6.worldBounds,
          textureSize = _this$state6.textureSize,
          weightsTexture = _this$state6.weightsTexture,
          weightsScale = _this$state6.weightsScale;

      var commonBounds = this._worldToCommonBounds(worldBounds, {
        useLayerCoordinateSystem: true
      });

      var uniforms = {
        radiusPixels: radiusPixels,
        commonBounds: commonBounds,
        textureWidth: textureSize,
        weightsScale: weightsScale
      };
      weightsTransform.update({
        elementCount: this.getNumInstances()
      });
      weightsTransform.run({
        uniforms: uniforms,
        parameters: {
          blend: true,
          depthTest: false,
          blendFunc: [1, 1],
          blendEquation: 32774
        },
        clearRenderTarget: true,
        attributes: this.getAttributes(),
        moduleSettings: this.getModuleSettings()
      });

      this._updateMaxWeightValue();

      weightsTexture.setParameters((_weightsTexture$setPa = {}, _defineProperty(_weightsTexture$setPa, 10240, 9729), _defineProperty(_weightsTexture$setPa, 10241, 9729), _weightsTexture$setPa));
      this.setState({
        lastUpdate: Date.now()
      });
    }
  }, {
    key: "_debouncedUpdateWeightmap",
    value: function _debouncedUpdateWeightmap() {
      var fromTimer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var updateTimer = this.state.updateTimer;
      var timeSinceLastUpdate = Date.now() - this.state.lastUpdate;

      if (fromTimer) {
        updateTimer = null;
      }

      if (timeSinceLastUpdate >= ZOOM_DEBOUNCE) {
        this._updateBounds(true);

        this._updateWeightmap();

        this._updateTextureRenderingBounds();
      } else if (!updateTimer) {
        updateTimer = setTimeout(this._debouncedUpdateWeightmap.bind(this, true), ZOOM_DEBOUNCE - timeSinceLastUpdate);
      }

      this.setState({
        updateTimer: updateTimer
      });
    }
  }, {
    key: "_worldToCommonBounds",
    value: function _worldToCommonBounds(worldBounds) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _opts$useLayerCoordin = opts.useLayerCoordinateSystem,
          useLayerCoordinateSystem = _opts$useLayerCoordin === void 0 ? false : _opts$useLayerCoordin;

      var _worldBounds = _slicedToArray(worldBounds, 4),
          minLong = _worldBounds[0],
          minLat = _worldBounds[1],
          maxLong = _worldBounds[2],
          maxLat = _worldBounds[3];

      var viewport = this.context.viewport;
      var textureSize = this.state.textureSize;
      var size = textureSize * RESOLUTION / viewport.scale;
      var bottomLeftCommon;
      var topRightCommon;

      if (useLayerCoordinateSystem) {
        bottomLeftCommon = this.projectPosition([minLong, minLat, 0]);
        topRightCommon = this.projectPosition([maxLong, maxLat, 0]);
      } else {
        bottomLeftCommon = viewport.projectPosition([minLong, minLat, 0]);
        topRightCommon = viewport.projectPosition([maxLong, maxLat, 0]);
      }

      var commonBounds = bottomLeftCommon.slice(0, 2).concat(topRightCommon.slice(0, 2));
      commonBounds = scaleToAspectRatio(commonBounds, size, size);
      return commonBounds;
    }
  }, {
    key: "_commonToWorldBounds",
    value: function _commonToWorldBounds(commonBounds) {
      var _commonBounds = _slicedToArray(commonBounds, 4),
          xMin = _commonBounds[0],
          yMin = _commonBounds[1],
          xMax = _commonBounds[2],
          yMax = _commonBounds[3];

      var viewport = this.context.viewport;
      var bottomLeftWorld = viewport.unprojectPosition([xMin, yMin]);
      var topRightWorld = viewport.unprojectPosition([xMax, yMax]);
      return bottomLeftWorld.slice(0, 2).concat(topRightWorld.slice(0, 2));
    }
  }]);

  return HeatmapLayer;
}(AggregationLayer);

export { HeatmapLayer as default };
HeatmapLayer.layerName = 'HeatmapLayer';
HeatmapLayer.defaultProps = defaultProps;
//# sourceMappingURL=heatmap-layer.js.map