"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _math = require("math.gl");

var _controller = _interopRequireDefault(require("./controller"));

var _mapController = require("./map-controller");

var _mathUtils = require("../utils/math-utils");

var _linearInterpolator = _interopRequireDefault(require("../transitions/linear-interpolator"));

var _transitionManager = require("./transition-manager");

var LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new _linearInterpolator["default"](['longitude', 'latitude', 'zoom']),
  transitionInterruption: _transitionManager.TRANSITION_EVENTS.BREAK
};

var GlobeState = function (_MapState) {
  (0, _inherits2["default"])(GlobeState, _MapState);

  function GlobeState() {
    (0, _classCallCheck2["default"])(this, GlobeState);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(GlobeState).apply(this, arguments));
  }

  (0, _createClass2["default"])(GlobeState, [{
    key: "_applyConstraints",
    value: function _applyConstraints(props) {
      var maxZoom = props.maxZoom,
          minZoom = props.minZoom,
          zoom = props.zoom;
      props.zoom = (0, _math.clamp)(zoom, minZoom, maxZoom);
      var longitude = props.longitude,
          latitude = props.latitude;

      if (longitude < -180 || longitude > 180) {
        props.longitude = (0, _mathUtils.mod)(longitude + 180, 360) - 180;
      }

      props.latitude = (0, _math.clamp)(latitude, -89, 89);
      return props;
    }
  }]);
  return GlobeState;
}(_mapController.MapState);

var GlobeController = function (_Controller) {
  (0, _inherits2["default"])(GlobeController, _Controller);

  function GlobeController(props) {
    var _this;

    (0, _classCallCheck2["default"])(this, GlobeController);
    _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(GlobeController).call(this, GlobeState, props));
    _this.invertPan = true;
    return _this;
  }

  (0, _createClass2["default"])(GlobeController, [{
    key: "setProps",
    value: function setProps(props) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(GlobeController.prototype), "setProps", this).call(this, props);
      this.dragRotate = false;
      this.touchRotate = false;
    }
  }, {
    key: "_getTransitionProps",
    value: function _getTransitionProps() {
      return LINEAR_TRANSITION_PROPS;
    }
  }]);
  return GlobeController;
}(_controller["default"]);

exports["default"] = GlobeController;
//# sourceMappingURL=globe-controller.js.map