"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DirectionalLight = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _math = require("math.gl");

var DEFAULT_LIGHT_COLOR = [255, 255, 255];
var DEFAULT_LIGHT_INTENSITY = 1.0;
var DEFAULT_LIGHT_DIRECTION = [0.0, 0.0, -1.0];
var idCount = 0;

var DirectionalLight = function () {
  function DirectionalLight() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, DirectionalLight);
    var _props$color = props.color,
        color = _props$color === void 0 ? DEFAULT_LIGHT_COLOR : _props$color;
    var _props$intensity = props.intensity,
        intensity = _props$intensity === void 0 ? DEFAULT_LIGHT_INTENSITY : _props$intensity;
    var _props$direction = props.direction,
        direction = _props$direction === void 0 ? DEFAULT_LIGHT_DIRECTION : _props$direction;

    var _props$_shadow = props._shadow,
        _shadow = _props$_shadow === void 0 ? false : _props$_shadow;

    this.id = props.id || "directional-".concat(idCount++);
    this.color = color;
    this.intensity = intensity;
    this.type = 'directional';
    this.direction = new _math.Vector3(direction).normalize().toArray();
    this.shadow = _shadow;
  }

  (0, _createClass2["default"])(DirectionalLight, [{
    key: "getProjectedLight",
    value: function getProjectedLight() {
      return this;
    }
  }]);
  return DirectionalLight;
}();

exports.DirectionalLight = DirectionalLight;
//# sourceMappingURL=directional-light.js.map