"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENTS = exports.PROJECTION_MODE = exports.COORDINATE_SYSTEM = void 0;

var _log = _interopRequireDefault(require("../utils/log"));

var COORDINATE_SYSTEM = {
  DEFAULT: -1,
  LNGLAT: 1,
  METER_OFFSETS: 2,
  LNGLAT_OFFSETS: 3,
  CARTESIAN: 0
};
exports.COORDINATE_SYSTEM = COORDINATE_SYSTEM;
Object.defineProperty(COORDINATE_SYSTEM, 'IDENTITY', {
  get: function get() {
    return _log["default"].deprecated('COORDINATE_SYSTEM.IDENTITY', 'COORDINATE_SYSTEM.CARTESIAN')() || 0;
  }
});
var PROJECTION_MODE = {
  WEB_MERCATOR: 1,
  GLOBE: 2,
  WEB_MERCATOR_AUTO_OFFSET: 4,
  IDENTITY: 0
};
exports.PROJECTION_MODE = PROJECTION_MODE;
var EVENTS = {
  click: {
    handler: 'onClick'
  },
  panstart: {
    handler: 'onDragStart'
  },
  panmove: {
    handler: 'onDrag'
  },
  panend: {
    handler: 'onDragEnd'
  }
};
exports.EVENTS = EVENTS;
//# sourceMappingURL=constants.js.map