"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _core = require("@loaders.gl/core");

var Resource = function () {
  function Resource(id, data, context) {
    (0, _classCallCheck2["default"])(this, Resource);
    this.id = id;
    this.context = context;
    this._loadCount = 0;
    this._subscribers = new Set();
    this.setData(data);
  }

  (0, _createClass2["default"])(Resource, [{
    key: "subscribe",
    value: function subscribe(consumer) {
      this._subscribers.add(consumer);
    }
  }, {
    key: "unsubscribe",
    value: function unsubscribe(consumer) {
      this._subscribers["delete"](consumer);
    }
  }, {
    key: "inUse",
    value: function inUse() {
      return this._subscribers.size > 0;
    }
  }, {
    key: "delete",
    value: function _delete() {}
  }, {
    key: "getData",
    value: function getData() {
      var _this = this;

      return this.isLoaded ? this._error ? Promise.reject(this._error) : this._content : this._loader.then(function () {
        return _this.getData();
      });
    }
  }, {
    key: "setData",
    value: function setData(data, forceUpdate) {
      var _this2 = this;

      if (data === this._data && !forceUpdate) {
        return;
      }

      this._data = data;
      var loadCount = ++this._loadCount;
      var loader = data;

      if (typeof data === 'string') {
        loader = (0, _core.load)(data);
      }

      if (loader instanceof Promise) {
        this.isLoaded = false;
        this._loader = loader.then(function (result) {
          if (_this2._loadCount === loadCount) {
            _this2.isLoaded = true;
            _this2._error = null;
            _this2._content = result;
          }
        })["catch"](function (error) {
          if (_this2._loadCount === loadCount) {
            _this2.isLoaded = true;
            _this2._error = error || true;
          }
        });
      } else {
        this.isLoaded = true;
        this._error = null;
        this._content = data;
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this._subscribers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var subscriber = _step.value;
          subscriber.onChange(this.getData());
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }]);
  return Resource;
}();

exports["default"] = Resource;
//# sourceMappingURL=resource.js.map