"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _layersPass = _interopRequireDefault(require("./layers-pass"));

var _core = require("@luma.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var PICKING_PARAMETERS = {
  blendFunc: [1, 0, 32771, 0],
  blendEquation: 32774
};

var PickLayersPass = function (_LayersPass) {
  (0, _inherits2["default"])(PickLayersPass, _LayersPass);

  function PickLayersPass() {
    (0, _classCallCheck2["default"])(this, PickLayersPass);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(PickLayersPass).apply(this, arguments));
  }

  (0, _createClass2["default"])(PickLayersPass, [{
    key: "render",
    value: function render(props) {
      if (props.pickingFBO) {
        this._drawPickingBuffer(props);
      } else {
        (0, _get2["default"])((0, _getPrototypeOf2["default"])(PickLayersPass.prototype), "render", this).call(this, props);
      }
    }
  }, {
    key: "_drawPickingBuffer",
    value: function _drawPickingBuffer(_ref) {
      var _this = this;

      var layers = _ref.layers,
          layerFilter = _ref.layerFilter,
          viewports = _ref.viewports,
          onViewportActive = _ref.onViewportActive,
          pickingFBO = _ref.pickingFBO,
          _ref$deviceRect = _ref.deviceRect,
          x = _ref$deviceRect.x,
          y = _ref$deviceRect.y,
          width = _ref$deviceRect.width,
          height = _ref$deviceRect.height,
          _ref$pass = _ref.pass,
          pass = _ref$pass === void 0 ? 'picking' : _ref$pass,
          redrawReason = _ref.redrawReason,
          pickZ = _ref.pickZ;
      var gl = this.gl;
      this.pickZ = pickZ;
      return (0, _core.withParameters)(gl, _objectSpread({
        scissorTest: true,
        scissor: [x, y, width, height],
        clearColor: [0, 0, 0, 0],
        depthMask: true,
        depthTest: true,
        depthRange: [0, 1],
        colorMask: [true, true, true, true]
      }, PICKING_PARAMETERS, {
        blend: !pickZ
      }), function () {
        (0, _get2["default"])((0, _getPrototypeOf2["default"])(PickLayersPass.prototype), "render", _this).call(_this, {
          target: pickingFBO,
          layers: layers,
          layerFilter: layerFilter,
          viewports: viewports,
          onViewportActive: onViewportActive,
          pass: pass,
          redrawReason: redrawReason
        });
      });
    }
  }, {
    key: "shouldDrawLayer",
    value: function shouldDrawLayer(layer) {
      return layer.props.pickable;
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters() {
      return {
        pickingActive: 1,
        pickingAttribute: this.pickZ,
        lightSources: {}
      };
    }
  }, {
    key: "getLayerParameters",
    value: function getLayerParameters(layer, layerIndex) {
      var pickParameters = this.pickZ ? {
        blend: false
      } : _objectSpread({}, PICKING_PARAMETERS, {
        blend: true,
        blendColor: [0, 0, 0, (layerIndex + 1) / 255]
      });
      return Object.assign({}, layer.props.parameters, pickParameters);
    }
  }]);
  return PickLayersPass;
}(_layersPass["default"]);

exports["default"] = PickLayersPass;
//# sourceMappingURL=pick-layers-pass.js.map