"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProgramManager = createProgramManager;
Object.defineProperty(exports, "gouraudLighting", {
  enumerable: true,
  get: function get() {
    return _core.gouraudLighting;
  }
});
Object.defineProperty(exports, "phongLighting", {
  enumerable: true,
  get: function get() {
    return _core.phongLighting;
  }
});
Object.defineProperty(exports, "project", {
  enumerable: true,
  get: function get() {
    return _project["default"];
  }
});
Object.defineProperty(exports, "project32", {
  enumerable: true,
  get: function get() {
    return _project2["default"];
  }
});
Object.defineProperty(exports, "shadow", {
  enumerable: true,
  get: function get() {
    return _shadow["default"];
  }
});
Object.defineProperty(exports, "picking", {
  enumerable: true,
  get: function get() {
    return _picking["default"];
  }
});

var _core = require("@luma.gl/core");

var _geometry = _interopRequireDefault(require("./misc/geometry"));

var _project = _interopRequireDefault(require("./project/project"));

var _project2 = _interopRequireDefault(require("./project32/project32"));

var _shadow = _interopRequireDefault(require("./shadow/shadow"));

var _picking = _interopRequireDefault(require("./picking/picking"));

var DEFAULT_MODULES = [_geometry["default"], _project["default"]];
var SHADER_HOOKS = ['vs:DECKGL_FILTER_SIZE(inout vec3 size, VertexGeometry geometry)', 'vs:DECKGL_FILTER_GL_POSITION(inout vec4 position, VertexGeometry geometry)', 'vs:DECKGL_FILTER_COLOR(inout vec4 color, VertexGeometry geometry)', 'fs:DECKGL_FILTER_COLOR(inout vec4 color, FragmentGeometry geometry)'];

function createProgramManager(gl) {
  var programManager = _core.ProgramManager.getDefaultProgramManager(gl);

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = DEFAULT_MODULES[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var shaderModule = _step.value;
      programManager.addDefaultModule(shaderModule);
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = SHADER_HOOKS[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var shaderHook = _step2.value;
      programManager.addShaderHook(shaderHook);
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
        _iterator2["return"]();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return programManager;
}
//# sourceMappingURL=index.js.map