"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _core = require("@luma.gl/core");

var _attribute = _interopRequireDefault(require("../lib/attribute/attribute"));

var _attributeTransitionUtils = require("../lib/attribute/attribute-transition-utils");

var _transition = _interopRequireDefault(require("./transition"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var GPUInterpolationTransition = function () {
  function GPUInterpolationTransition(_ref) {
    var gl = _ref.gl,
        attribute = _ref.attribute,
        timeline = _ref.timeline;
    (0, _classCallCheck2["default"])(this, GPUInterpolationTransition);
    this.gl = gl;
    this.type = 'interpolation';
    this.transition = new _transition["default"](timeline);
    this.attribute = attribute;
    this.attributeInTransition = new _attribute["default"](gl, attribute.settings);
    this.currentStartIndices = attribute.startIndices;
    this.currentLength = 0;
    this.transform = getTransform(gl, attribute);
    var bufferOpts = {
      byteLength: 0,
      usage: 35050
    };
    this.buffers = [new _core.Buffer(gl, bufferOpts), new _core.Buffer(gl, bufferOpts)];
  }

  (0, _createClass2["default"])(GPUInterpolationTransition, [{
    key: "start",
    value: function start(transitionSettings, numInstances) {
      if (transitionSettings.duration <= 0) {
        this.transition.cancel();
        return;
      }

      var gl = this.gl,
          buffers = this.buffers,
          attribute = this.attribute;
      (0, _attributeTransitionUtils.cycleBuffers)(buffers);
      var padBufferOpts = {
        numInstances: numInstances,
        attribute: attribute,
        fromLength: this.currentLength,
        fromStartIndices: this.currentStartIndices,
        getData: transitionSettings.enter
      };
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = buffers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var buffer = _step.value;
          (0, _attributeTransitionUtils.padBuffer)(_objectSpread({
            buffer: buffer
          }, padBufferOpts));
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.currentStartIndices = attribute.startIndices;
      this.currentLength = (0, _attributeTransitionUtils.getAttributeBufferLength)(attribute, numInstances);
      this.attributeInTransition.update({
        buffer: buffers[1],
        value: attribute.value
      });
      this.transition.start(transitionSettings);
      this.transform.update({
        elementCount: Math.floor(this.currentLength / attribute.size),
        sourceBuffers: {
          aFrom: buffers[0],
          aTo: (0, _attributeTransitionUtils.getSourceBufferAttribute)(gl, attribute)
        },
        feedbackBuffers: {
          vCurrent: buffers[1]
        }
      });
    }
  }, {
    key: "update",
    value: function update() {
      var updated = this.transition.update();

      if (updated) {
        var _this$transition = this.transition,
            time = _this$transition.time,
            _this$transition$sett = _this$transition.settings,
            duration = _this$transition$sett.duration,
            easing = _this$transition$sett.easing;
        var t = easing(time / duration);
        this.transform.run({
          uniforms: {
            time: t
          }
        });
      }

      return updated;
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this.transition.cancel();
      this.transform["delete"]();

      while (this.buffers.length) {
        this.buffers.pop()["delete"]();
      }
    }
  }, {
    key: "inProgress",
    get: function get() {
      return this.transition.inProgress;
    }
  }]);
  return GPUInterpolationTransition;
}();

exports["default"] = GPUInterpolationTransition;
var vs = "\n#define SHADER_NAME interpolation-transition-vertex-shader\n\nuniform float time;\nattribute ATTRIBUTE_TYPE aFrom;\nattribute ATTRIBUTE_TYPE aTo;\nvarying ATTRIBUTE_TYPE vCurrent;\n\nvoid main(void) {\n  vCurrent = mix(aFrom, aTo, time);\n  gl_Position = vec4(0.0);\n}\n";

function getTransform(gl, attribute) {
  var attributeType = (0, _attributeTransitionUtils.getAttributeTypeFromSize)(attribute.size);
  return new _core.Transform(gl, {
    vs: vs,
    defines: {
      ATTRIBUTE_TYPE: attributeType
    },
    varyings: ['vCurrent']
  });
}
//# sourceMappingURL=gpu-interpolation-transition.js.map