"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _math = require("math.gl");

var _viewport = _interopRequireDefault(require("./viewport"));

var _constants = require("../lib/constants");

var vec3 = _interopRequireWildcard(require("gl-matrix/vec3"));

var vec4 = _interopRequireWildcard(require("gl-matrix/vec4"));

var DEGREES_TO_RADIANS = Math.PI / 180;
var RADIANS_TO_DEGREES = 180 / Math.PI;
var EARTH_RADIUS = 6370972;
var GLOBE_RADIUS = 256;

function getDistanceScales() {
  var unitsPerMeter = GLOBE_RADIUS / EARTH_RADIUS;
  var unitsPerDegree = Math.PI / 180 * GLOBE_RADIUS;
  return {
    unitsPerMeter: [unitsPerMeter, unitsPerMeter, unitsPerMeter],
    unitsPerMeter2: [0, 0, 0],
    metersPerUnit: [1 / unitsPerMeter, 1 / unitsPerMeter, 1 / unitsPerMeter],
    unitsPerDegree: [unitsPerDegree, unitsPerDegree, unitsPerMeter],
    unitsPerDegree2: [0, 0, 0],
    degreesPerUnit: [1 / unitsPerDegree, 1 / unitsPerDegree, 1 / unitsPerMeter]
  };
}

var GlobeViewport = function (_Viewport) {
  (0, _inherits2["default"])(GlobeViewport, _Viewport);

  function GlobeViewport() {
    var _this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, GlobeViewport);
    var _opts$latitude = opts.latitude,
        latitude = _opts$latitude === void 0 ? 0 : _opts$latitude,
        _opts$longitude = opts.longitude,
        longitude = _opts$longitude === void 0 ? 0 : _opts$longitude,
        _opts$zoom = opts.zoom,
        zoom = _opts$zoom === void 0 ? 11 : _opts$zoom,
        _opts$nearZMultiplier = opts.nearZMultiplier,
        nearZMultiplier = _opts$nearZMultiplier === void 0 ? 0.1 : _opts$nearZMultiplier,
        _opts$farZMultiplier = opts.farZMultiplier,
        farZMultiplier = _opts$farZMultiplier === void 0 ? 1 : _opts$farZMultiplier,
        _opts$resolution = opts.resolution,
        resolution = _opts$resolution === void 0 ? 10 : _opts$resolution;
    var width = opts.width,
        height = opts.height,
        _opts$altitude = opts.altitude,
        altitude = _opts$altitude === void 0 ? 1.5 : _opts$altitude;
    width = width || 1;
    height = height || 1;
    altitude = Math.max(0.75, altitude);
    var viewMatrix = new _math.Matrix4().lookAt({
      eye: [0, -altitude, 0],
      up: [0, 0, 1]
    });
    var scale = Math.pow(2, zoom);
    viewMatrix.rotateX(latitude * DEGREES_TO_RADIANS);
    viewMatrix.rotateZ(-longitude * DEGREES_TO_RADIANS);
    viewMatrix.scale(scale / height);
    var halfFov = Math.atan(0.5 / altitude);
    var relativeScale = GLOBE_RADIUS * 2 * scale / height;
    var viewportOpts = Object.assign({}, opts, {
      width: width,
      height: height,
      viewMatrix: viewMatrix,
      longitude: longitude,
      latitude: latitude,
      zoom: zoom,
      fovyRadians: halfFov * 2,
      aspect: width / height,
      focalDistance: altitude,
      near: nearZMultiplier,
      far: Math.min(2, 1 / relativeScale + 1) * altitude * farZMultiplier
    });
    _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(GlobeViewport).call(this, viewportOpts));
    _this.resolution = resolution;
    _this.distanceScales = getDistanceScales();
    return _this;
  }

  (0, _createClass2["default"])(GlobeViewport, [{
    key: "getDistanceScales",
    value: function getDistanceScales() {
      return this.distanceScales;
    }
  }, {
    key: "unproject",
    value: function unproject(xyz) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$topLeft = _ref.topLeft,
          topLeft = _ref$topLeft === void 0 ? true : _ref$topLeft,
          targetZ = _ref.targetZ;

      var _xyz = (0, _slicedToArray2["default"])(xyz, 3),
          x = _xyz[0],
          y = _xyz[1],
          z = _xyz[2];

      var y2 = topLeft ? y : this.height - y;
      var pixelUnprojectionMatrix = this.pixelUnprojectionMatrix;
      var coord;

      if (Number.isFinite(z)) {
        coord = transformVector(pixelUnprojectionMatrix, [x, y2, z, 1]);
      } else {
        var coord0 = transformVector(pixelUnprojectionMatrix, [x, y2, -1, 1]);
        var coord1 = transformVector(pixelUnprojectionMatrix, [x, y2, 1, 1]);
        var lt = ((targetZ || 0) / EARTH_RADIUS + 1) * GLOBE_RADIUS;
        var lSqr = vec3.sqrLen(vec3.sub([], coord0, coord1));
        var l0Sqr = vec3.sqrLen(coord0);
        var l1Sqr = vec3.sqrLen(coord1);
        var sSqr = (4 * l0Sqr * l1Sqr - Math.pow(lSqr - l0Sqr - l1Sqr, 2)) / 16;
        var dSqr = 4 * sSqr / lSqr;
        var r0 = Math.sqrt(l0Sqr - dSqr);
        var dr = Math.sqrt(Math.max(0, lt * lt - dSqr));
        var t = (r0 - dr) / Math.sqrt(lSqr);
        coord = vec3.lerp([], coord0, coord1, t);
      }

      var _this$unprojectPositi = this.unprojectPosition(coord),
          _this$unprojectPositi2 = (0, _slicedToArray2["default"])(_this$unprojectPositi, 3),
          X = _this$unprojectPositi2[0],
          Y = _this$unprojectPositi2[1],
          Z = _this$unprojectPositi2[2];

      if (Number.isFinite(z)) {
        return [X, Y, Z];
      }

      return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
    }
  }, {
    key: "projectPosition",
    value: function projectPosition(xyz) {
      var _xyz2 = (0, _slicedToArray2["default"])(xyz, 3),
          lng = _xyz2[0],
          lat = _xyz2[1],
          _xyz2$ = _xyz2[2],
          Z = _xyz2$ === void 0 ? 0 : _xyz2$;

      var lambda = lng * DEGREES_TO_RADIANS;
      var phi = lat * DEGREES_TO_RADIANS;
      var cosPhi = Math.cos(phi);
      var D = (Z / EARTH_RADIUS + 1) * GLOBE_RADIUS;
      return [Math.sin(lambda) * cosPhi * D, -Math.cos(lambda) * cosPhi * D, Math.sin(phi) * D];
    }
  }, {
    key: "unprojectPosition",
    value: function unprojectPosition(xyz) {
      var _xyz3 = (0, _slicedToArray2["default"])(xyz, 3),
          x = _xyz3[0],
          y = _xyz3[1],
          z = _xyz3[2];

      var D = vec3.len(xyz);
      var phi = Math.asin(z / D);
      var lambda = Math.atan2(x, -y);
      var lng = lambda * RADIANS_TO_DEGREES;
      var lat = phi * RADIANS_TO_DEGREES;
      var Z = (D / GLOBE_RADIUS - 1) * EARTH_RADIUS;
      return [lng, lat, Z];
    }
  }, {
    key: "projectFlat",
    value: function projectFlat(xyz) {
      return xyz;
    }
  }, {
    key: "unprojectFlat",
    value: function unprojectFlat(xyz) {
      return xyz;
    }
  }, {
    key: "getMapCenterByLngLatPosition",
    value: function getMapCenterByLngLatPosition(_ref2) {
      var lngLat = _ref2.lngLat,
          pos = _ref2.pos;
      var fromPosition = this.unproject(pos);
      return [lngLat[0] - fromPosition[0] + this.longitude, lngLat[1] - fromPosition[1] + this.latitude];
    }
  }, {
    key: "projectionMode",
    get: function get() {
      return _constants.PROJECTION_MODE.GLOBE;
    }
  }]);
  return GlobeViewport;
}(_viewport["default"]);

exports["default"] = GlobeViewport;

function transformVector(matrix, vector) {
  var result = vec4.transformMat4([], vector, matrix);
  vec4.scale(result, result, 1 / result[3]);
  return result;
}
//# sourceMappingURL=globe-viewport.js.map