import assert from '../utils/assert';
export default class ViewState {
  constructor(opts) {
    assert(Number.isFinite(opts.width), '`width` must be supplied');
    assert(Number.isFinite(opts.height), '`height` must be supplied');
    this._viewportProps = this._applyConstraints(opts);
  }

  getViewportProps() {
    return this._viewportProps;
  }

  shortestPathFrom(viewState) {
    return this._viewportProps;
  }

  _applyConstraints(props) {
    return props;
  }

}
//# sourceMappingURL=view-state.js.map