export function processPickInfo({
  pickInfo,
  lastPickedInfo,
  mode,
  layers,
  viewports,
  x,
  y,
  z,
  pixelRatio
}) {
  const {
    pickedColor,
    pickedLayer,
    pickedObjectIndex
  } = pickInfo;
  const affectedLayers = pickedLayer ? [pickedLayer] : [];

  if (mode === 'hover') {
    const lastPickedObjectIndex = lastPickedInfo.index;
    const lastPickedLayerId = lastPickedInfo.layerId;
    const pickedLayerId = pickedLayer && pickedLayer.props.id;

    if (pickedLayerId !== lastPickedLayerId || pickedObjectIndex !== lastPickedObjectIndex) {
      if (pickedLayerId !== lastPickedLayerId) {
        const lastPickedLayer = layers.find(layer => layer.props.id === lastPickedLayerId);

        if (lastPickedLayer) {
          affectedLayers.unshift(lastPickedLayer);
        }
      }

      lastPickedInfo.layerId = pickedLayerId;
      lastPickedInfo.index = pickedObjectIndex;
      lastPickedInfo.info = null;
    }
  }

  const viewport = getViewportFromCoordinates({
    viewports
  });
  const coordinate = viewport && viewport.unproject([x - viewport.x, y - viewport.y], {
    targetZ: z
  });
  const baseInfo = {
    color: null,
    layer: null,
    index: -1,
    picked: false,
    x,
    y,
    pixel: [x, y],
    coordinate,
    lngLat: coordinate,
    devicePixel: [pickInfo.pickedX, pickInfo.pickedY],
    pixelRatio
  };
  const infos = new Map();
  infos.set(null, baseInfo);
  affectedLayers.forEach(layer => {
    let info = Object.assign({}, baseInfo);

    if (layer === pickedLayer) {
      info.color = pickedColor;
      info.index = pickedObjectIndex;
      info.picked = true;
    }

    info = getLayerPickingInfo({
      layer,
      info,
      mode
    });

    if (layer === pickedLayer && mode === 'hover') {
      lastPickedInfo.info = info;
    }

    if (info) {
      infos.set(info.layer.id, info);
    }

    if (mode === 'hover' && layer.props.autoHighlight) {
      const pickingModuleParameters = {
        pickingSelectedColor: pickedLayer === layer ? pickedColor : null
      };
      const {
        highlightColor
      } = layer.props;

      if (pickedLayer === layer && typeof highlightColor === 'function') {
        pickingModuleParameters.pickingHighlightColor = highlightColor(info);
      }

      layer.setModuleParameters(pickingModuleParameters);
      layer.setNeedsRedraw();
    }
  });
  return infos;
}
export function getLayerPickingInfo({
  layer,
  info,
  mode
}) {
  while (layer && info) {
    const sourceLayer = info.layer || layer;
    info.layer = layer;
    info = layer.getPickingInfo({
      info,
      mode,
      sourceLayer
    });
    layer = layer.parent;
  }

  return info;
}

function getViewportFromCoordinates({
  viewports
}) {
  const viewport = viewports[0];
  return viewport;
}
//# sourceMappingURL=pick-info.js.map