import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { normalizeTransitionSettings } from './attribute/attribute-transition-utils';
import CPUInterpolationTransition from '../transitions/cpu-interpolation-transition';
import CPUSpringTransition from '../transitions/cpu-spring-transition';
import log from '../utils/log';
const TRANSITION_TYPES = {
  interpolation: CPUInterpolationTransition,
  spring: CPUSpringTransition
};
export default class UniformTransitionManager {
  constructor(timeline) {
    this.transitions = new Map();
    this.timeline = timeline;
  }

  get active() {
    return this.transitions.size > 0;
  }

  add(key, fromValue, toValue, settings) {
    const {
      transitions
    } = this;

    if (transitions.has(key)) {
      const transition = transitions.get(key);
      fromValue = transition.value;
      this.remove(key);
    }

    settings = normalizeTransitionSettings(settings);

    if (!settings) {
      return;
    }

    const TransitionType = TRANSITION_TYPES[settings.type];

    if (!TransitionType) {
      log.error("unsupported transition type '".concat(settings.type, "'"))();
      return;
    }

    const transition = new TransitionType(this.timeline);
    transition.start(_objectSpread({}, settings, {
      fromValue,
      toValue
    }));
    transitions.set(key, transition);
  }

  remove(key) {
    const {
      transitions
    } = this;

    if (transitions.has(key)) {
      transitions.get(key).cancel();
      transitions.delete(key);
    }
  }

  update() {
    const propsInTransition = {};

    for (const [key, transition] of this.transitions) {
      transition.update();
      propsInTransition[key] = transition.value;

      if (!transition.inProgress) {
        this.remove(key);
      }
    }

    return propsInTransition;
  }

  clear() {
    for (const key of this.transitions.keys()) {
      this.remove(key);
    }
  }

}
//# sourceMappingURL=uniform-transition-manager.js.map