import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import LayersPass from './layers-pass';
import { withParameters } from '@luma.gl/core';
const PICKING_PARAMETERS = {
  blendFunc: [1, 0, 32771, 0],
  blendEquation: 32774
};
export default class PickLayersPass extends LayersPass {
  render(props) {
    if (props.pickingFBO) {
      this._drawPickingBuffer(props);
    } else {
      super.render(props);
    }
  }

  _drawPickingBuffer({
    layers,
    layerFilter,
    viewports,
    onViewportActive,
    pickingFBO,
    deviceRect: {
      x,
      y,
      width,
      height
    },
    pass = 'picking',
    redrawReason,
    pickZ
  }) {
    const gl = this.gl;
    this.pickZ = pickZ;
    return withParameters(gl, _objectSpread({
      scissorTest: true,
      scissor: [x, y, width, height],
      clearColor: [0, 0, 0, 0],
      depthMask: true,
      depthTest: true,
      depthRange: [0, 1],
      colorMask: [true, true, true, true]
    }, PICKING_PARAMETERS, {
      blend: !pickZ
    }), () => {
      super.render({
        target: pickingFBO,
        layers,
        layerFilter,
        viewports,
        onViewportActive,
        pass,
        redrawReason
      });
    });
  }

  shouldDrawLayer(layer) {
    return layer.props.pickable;
  }

  getModuleParameters() {
    return {
      pickingActive: 1,
      pickingAttribute: this.pickZ,
      lightSources: {}
    };
  }

  getLayerParameters(layer, layerIndex) {
    const pickParameters = this.pickZ ? {
      blend: false
    } : _objectSpread({}, PICKING_PARAMETERS, {
      blend: true,
      blendColor: [0, 0, 0, (layerIndex + 1) / 255]
    });
    return Object.assign({}, layer.props.parameters, pickParameters);
  }

}
//# sourceMappingURL=pick-layers-pass.js.map