import { ClipSpace, withParameters, clear } from '@luma.gl/core';
import Pass from './pass';
export default class ScreenPass extends Pass {
  constructor(gl, props = {}) {
    super(gl, props);
    const {
      module,
      fs,
      id
    } = props;
    this.model = new ClipSpace(gl, {
      id,
      fs,
      modules: [module]
    });
  }

  render(params) {
    const gl = this.gl;
    withParameters(gl, {
      framebuffer: params.outputBuffer,
      clearColor: [0, 0, 0, 0]
    }, () => this._renderPass(gl, params));
  }

  delete() {
    this.model.delete();
    this.model = null;
  }

  _renderPass(gl, {
    inputBuffer,
    outputBuffer
  }) {
    clear(gl, {
      color: true
    });
    this.model.draw({
      moduleSettings: this.props.moduleSettings,
      uniforms: {
        texture: inputBuffer,
        texSize: [inputBuffer.width, inputBuffer.height]
      },
      parameters: {
        depthWrite: false,
        depthTest: false
      }
    });
  }

}
//# sourceMappingURL=screen-pass.js.map