import { ProgramManager } from '@luma.gl/core';
import { gouraudLighting, phongLighting } from '@luma.gl/core';
import geometry from './misc/geometry';
import project from './project/project';
import project32 from './project32/project32';
import shadow from './shadow/shadow';
import picking from './picking/picking';
const DEFAULT_MODULES = [geometry, project];
const SHADER_HOOKS = ['vs:DECKGL_FILTER_SIZE(inout vec3 size, VertexGeometry geometry)', 'vs:DECKGL_FILTER_GL_POSITION(inout vec4 position, VertexGeometry geometry)', 'vs:DECKGL_FILTER_COLOR(inout vec4 color, VertexGeometry geometry)', 'fs:DECKGL_FILTER_COLOR(inout vec4 color, FragmentGeometry geometry)'];
export function createProgramManager(gl) {
  const programManager = ProgramManager.getDefaultProgramManager(gl);

  for (const shaderModule of DEFAULT_MODULES) {
    programManager.addDefaultModule(shaderModule);
  }

  for (const shaderHook of SHADER_HOOKS) {
    programManager.addShaderHook(shaderHook);
  }

  return programManager;
}
export { picking, project, project32, gouraudLighting, phongLighting, shadow };
//# sourceMappingURL=index.js.map