import { fp32 } from '@luma.gl/core';
import projectShader from './project.glsl';
import { getUniformsFromViewport } from './viewport-uniforms';
const INITIAL_MODULE_OPTIONS = {};

function getUniforms(opts = INITIAL_MODULE_OPTIONS) {
  if (opts.viewport) {
    return getUniformsFromViewport(opts);
  }

  return {};
}

export default {
  name: 'project',
  dependencies: [fp32],
  vs: projectShader,
  getUniforms
};
//# sourceMappingURL=project.js.map