function noop() {}

const DEFAULT_SETTINGS = {
  onStart: noop,
  onUpdate: noop,
  onInterrupt: noop,
  onEnd: noop
};
export default class Transition {
  constructor(timeline) {
    this._inProgress = false;
    this._handle = null;
    this.timeline = timeline;
    this.settings = {};
  }

  get inProgress() {
    return this._inProgress;
  }

  start(props) {
    this.cancel();
    this.settings = Object.assign({}, DEFAULT_SETTINGS, props);
    this._inProgress = true;
    this.settings.onStart(this);
  }

  end() {
    if (this._inProgress) {
      this.timeline.removeChannel(this._handle);
      this._handle = null;
      this._inProgress = false;
      this.settings.onEnd(this);
    }
  }

  cancel() {
    if (this._inProgress) {
      this.settings.onInterrupt(this);
      this.timeline.removeChannel(this._handle);
      this._handle = null;
      this._inProgress = false;
    }
  }

  update() {
    if (!this._inProgress) {
      return false;
    }

    if (this._handle === null) {
      const {
        timeline,
        settings
      } = this;
      this._handle = timeline.addChannel({
        delay: timeline.getTime(),
        duration: settings.duration
      });
    }

    this.time = this.timeline.getTime(this._handle);

    this._onUpdate();

    this.settings.onUpdate(this);

    if (this.timeline.isFinished(this._handle)) {
      this.end();
    }

    return true;
  }

  _onUpdate() {}

}
//# sourceMappingURL=transition.js.map