import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import Controller from './controller';
import ViewState from './view-state';
import { mod } from '../utils/math-utils';
import { Vector3, _SphericalCoordinates as SphericalCoordinates, clamp } from 'math.gl';
var MOVEMENT_SPEED = 20;
var DEFAULT_STATE = {
  position: [0, 0, 0],
  pitch: 0,
  bearing: 0,
  maxPitch: 90,
  minPitch: -90
};

var FirstPersonState = function (_ViewState) {
  _inherits(FirstPersonState, _ViewState);

  function FirstPersonState(_ref) {
    var _this;

    var width = _ref.width,
        height = _ref.height,
        _ref$position = _ref.position,
        position = _ref$position === void 0 ? DEFAULT_STATE.position : _ref$position,
        _ref$bearing = _ref.bearing,
        bearing = _ref$bearing === void 0 ? DEFAULT_STATE.bearing : _ref$bearing,
        _ref$pitch = _ref.pitch,
        pitch = _ref$pitch === void 0 ? DEFAULT_STATE.pitch : _ref$pitch,
        longitude = _ref.longitude,
        latitude = _ref.latitude,
        _ref$maxPitch = _ref.maxPitch,
        maxPitch = _ref$maxPitch === void 0 ? DEFAULT_STATE.maxPitch : _ref$maxPitch,
        _ref$minPitch = _ref.minPitch,
        minPitch = _ref$minPitch === void 0 ? DEFAULT_STATE.minPitch : _ref$minPitch,
        startBearing = _ref.startBearing,
        startPitch = _ref.startPitch,
        startZoomPosition = _ref.startZoomPosition,
        startZoom = _ref.startZoom;

    _classCallCheck(this, FirstPersonState);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FirstPersonState).call(this, {
      width: width,
      height: height,
      position: position,
      bearing: bearing,
      pitch: pitch,
      longitude: longitude,
      latitude: latitude,
      maxPitch: maxPitch,
      minPitch: minPitch
    }));
    _this._interactiveState = {
      startBearing: startBearing,
      startPitch: startPitch,
      startZoomPosition: startZoomPosition,
      startZoom: startZoom
    };
    return _this;
  }

  _createClass(FirstPersonState, [{
    key: "getInteractiveState",
    value: function getInteractiveState() {
      return this._interactiveState;
    }
  }, {
    key: "getDirection",
    value: function getDirection() {
      var use2D = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var spherical = new SphericalCoordinates({
        bearing: this._viewportProps.bearing,
        pitch: use2D ? 90 : 90 + this._viewportProps.pitch
      });
      var direction = spherical.toVector3().normalize();
      return direction;
    }
  }, {
    key: "panStart",
    value: function panStart() {
      return this;
    }
  }, {
    key: "pan",
    value: function pan() {
      return this;
    }
  }, {
    key: "panEnd",
    value: function panEnd() {
      return this;
    }
  }, {
    key: "rotateStart",
    value: function rotateStart(_ref2) {
      var pos = _ref2.pos;
      return this._getUpdatedState({
        startBearing: this._viewportProps.bearing,
        startPitch: this._viewportProps.pitch
      });
    }
  }, {
    key: "rotate",
    value: function rotate(_ref3) {
      var deltaScaleX = _ref3.deltaScaleX,
          deltaScaleY = _ref3.deltaScaleY;
      var _this$_interactiveSta = this._interactiveState,
          startBearing = _this$_interactiveSta.startBearing,
          startPitch = _this$_interactiveSta.startPitch;

      if (!Number.isFinite(startBearing) || !Number.isFinite(startPitch)) {
        return this;
      }

      return this._getUpdatedState({
        bearing: startBearing - deltaScaleX * 180,
        pitch: startPitch - deltaScaleY * 90
      });
    }
  }, {
    key: "rotateEnd",
    value: function rotateEnd() {
      return this._getUpdatedState({
        startBearing: null,
        startPitch: null
      });
    }
  }, {
    key: "zoomStart",
    value: function zoomStart() {
      return this._getUpdatedState({
        startZoomPosition: this._viewportProps.position,
        startZoom: this._viewportProps.zoom
      });
    }
  }, {
    key: "zoom",
    value: function zoom(_ref4) {
      var scale = _ref4.scale;
      var startZoomPosition = this._interactiveState.startZoomPosition;

      if (!startZoomPosition) {
        startZoomPosition = this._viewportProps.position;
      }

      var direction = this.getDirection();
      return this._move(direction, Math.log2(scale), startZoomPosition);
    }
  }, {
    key: "zoomEnd",
    value: function zoomEnd() {
      return this._getUpdatedState({
        startZoomPosition: null,
        startZoom: null
      });
    }
  }, {
    key: "moveLeft",
    value: function moveLeft() {
      var direction = this.getDirection(true);
      return this._move(direction.rotateZ({
        radians: Math.PI / 2
      }));
    }
  }, {
    key: "moveRight",
    value: function moveRight() {
      var direction = this.getDirection(true);
      return this._move(direction.rotateZ({
        radians: -Math.PI / 2
      }));
    }
  }, {
    key: "moveUp",
    value: function moveUp() {
      var direction = this.getDirection(true);
      return this._move(direction);
    }
  }, {
    key: "moveDown",
    value: function moveDown() {
      var direction = this.getDirection(true);
      return this._move(direction.negate());
    }
  }, {
    key: "rotateLeft",
    value: function rotateLeft() {
      return this._getUpdatedState({
        bearing: this._viewportProps.bearing - 15
      });
    }
  }, {
    key: "rotateRight",
    value: function rotateRight() {
      return this._getUpdatedState({
        bearing: this._viewportProps.bearing + 15
      });
    }
  }, {
    key: "rotateUp",
    value: function rotateUp() {
      return this._getUpdatedState({
        pitch: this._viewportProps.pitch + 10
      });
    }
  }, {
    key: "rotateDown",
    value: function rotateDown() {
      return this._getUpdatedState({
        pitch: this._viewportProps.pitch - 10
      });
    }
  }, {
    key: "zoomIn",
    value: function zoomIn() {
      return this.zoom({
        scale: 2
      });
    }
  }, {
    key: "zoomOut",
    value: function zoomOut() {
      return this.zoom({
        scale: 0.5
      });
    }
  }, {
    key: "shortestPathFrom",
    value: function shortestPathFrom(viewState) {
      var fromProps = viewState.getViewportProps();
      var props = Object.assign({}, this._viewportProps);
      var bearing = props.bearing,
          longitude = props.longitude;

      if (Math.abs(bearing - fromProps.bearing) > 180) {
        props.bearing = bearing < 0 ? bearing + 360 : bearing - 360;
      }

      if (Math.abs(longitude - fromProps.longitude) > 180) {
        props.longitude = longitude < 0 ? longitude + 360 : longitude - 360;
      }

      return props;
    }
  }, {
    key: "_move",
    value: function _move(direction) {
      var speed = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var fromPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._viewportProps.position;
      var delta = direction.scale(speed * MOVEMENT_SPEED);
      return this._getUpdatedState({
        position: new Vector3(fromPosition).add(delta)
      });
    }
  }, {
    key: "_getUpdatedState",
    value: function _getUpdatedState(newProps) {
      return new FirstPersonState(Object.assign({}, this._viewportProps, this._interactiveState, newProps));
    }
  }, {
    key: "_applyConstraints",
    value: function _applyConstraints(props) {
      var pitch = props.pitch,
          maxPitch = props.maxPitch,
          minPitch = props.minPitch,
          longitude = props.longitude,
          bearing = props.bearing;
      props.pitch = clamp(pitch, minPitch, maxPitch);

      if (longitude < -180 || longitude > 180) {
        props.longitude = mod(longitude + 180, 360) - 180;
      }

      if (bearing < -180 || bearing > 180) {
        props.bearing = mod(bearing + 180, 360) - 180;
      }

      return props;
    }
  }]);

  return FirstPersonState;
}(ViewState);

var FirstPersonController = function (_Controller) {
  _inherits(FirstPersonController, _Controller);

  function FirstPersonController(props) {
    _classCallCheck(this, FirstPersonController);

    return _possibleConstructorReturn(this, _getPrototypeOf(FirstPersonController).call(this, FirstPersonState, props));
  }

  return FirstPersonController;
}(Controller);

export { FirstPersonController as default };
//# sourceMappingURL=first-person-controller.js.map