var logState = {
  attributeUpdateMessages: []
};
var LOG_LEVEL_MAJOR_UPDATE = 1;
var LOG_LEVEL_MINOR_UPDATE = 2;
var LOG_LEVEL_UPDATE_DETAIL = 3;
var LOG_LEVEL_INFO = 4;
var LOG_LEVEL_DRAW = 2;
export var getLoggers = function getLoggers(log) {
  return {
    'layer.changeFlag': function layerChangeFlag(layer, key, flags) {
      log.log(LOG_LEVEL_UPDATE_DETAIL, "".concat(layer.id, " ").concat(key, ": "), flags[key])();
    },
    'layer.initialize': function layerInitialize(layer) {
      log.log(LOG_LEVEL_MAJOR_UPDATE, "Initializing ".concat(layer))();
    },
    'layer.update': function layerUpdate(layer, needsUpdate) {
      if (needsUpdate) {
        var flags = layer.getChangeFlags();
        log.log(LOG_LEVEL_MINOR_UPDATE, "Updating ".concat(layer, " because: ").concat(Object.keys(flags).filter(function (key) {
          return flags[key];
        }).join(', ')))();
      } else {
        log.log(LOG_LEVEL_INFO, "".concat(layer, " does not need update"))();
      }
    },
    'layer.matched': function layerMatched(layer, changed) {
      if (changed) {
        log.log(LOG_LEVEL_INFO, "Matched ".concat(layer, ", state transfered"))();
      }
    },
    'layer.finalize': function layerFinalize(layer) {
      log.log(LOG_LEVEL_MAJOR_UPDATE, "Finalizing ".concat(layer))();
    },
    'compositeLayer.renderLayers': function compositeLayerRenderLayers(layer, updated, subLayers) {
      if (updated) {
        log.log(LOG_LEVEL_MINOR_UPDATE, "Composite layer rendered new subLayers ".concat(layer), subLayers)();
      } else {
        log.log(LOG_LEVEL_INFO, "Composite layer reused subLayers ".concat(layer), subLayers)();
      }
    },
    'layerManager.setLayers': function layerManagerSetLayers(layerManager, updated, layers) {
      if (updated) {
        log.log(LOG_LEVEL_MINOR_UPDATE, "Updating ".concat(layers.length, " deck layers"))();
      }
    },
    'layerManager.activateViewport': function layerManagerActivateViewport(layerManager, viewport) {
      log.log(LOG_LEVEL_UPDATE_DETAIL, 'Viewport changed', viewport)();
    },
    'attributeManager.invalidate': function attributeManagerInvalidate(attributeManager, trigger, attributeNames) {
      log.log(LOG_LEVEL_MAJOR_UPDATE, attributeNames ? "invalidated attributes ".concat(attributeNames, " (").concat(trigger, ") for ").concat(attributeManager.id) : "invalidated all attributes for ".concat(attributeManager.id))();
    },
    'attributeManager.updateStart': function attributeManagerUpdateStart(attributeManager) {
      logState.attributeUpdateMessages.length = 0;
      logState.attributeManagerUpdateStart = Date.now();
    },
    'attributeManager.updateEnd': function attributeManagerUpdateEnd(attributeManager, numInstances) {
      var timeMs = Math.round(Date.now() - logState.attributeManagerUpdateStart);
      log.groupCollapsed(LOG_LEVEL_MINOR_UPDATE, "Updated attributes for ".concat(numInstances, " instances in ").concat(attributeManager.id, " in ").concat(timeMs, "ms"))();
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = logState.attributeUpdateMessages[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var updateMessage = _step.value;
          log.log(LOG_LEVEL_UPDATE_DETAIL, updateMessage)();
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      log.groupEnd(LOG_LEVEL_MINOR_UPDATE)();
    },
    'attribute.updateStart': function attributeUpdateStart(attribute) {
      logState.attributeUpdateStart = Date.now();
    },
    'attribute.allocate': function attributeAllocate(attribute, numInstances) {
      var message = "".concat(attribute.id, " allocated ").concat(numInstances);
      logState.attributeUpdateMessages.push(message);
    },
    'attribute.updateEnd': function attributeUpdateEnd(attribute, numInstances) {
      var timeMs = Math.round(Date.now() - logState.attributeUpdateStart);
      var message = "".concat(attribute.id, " updated ").concat(numInstances, " in ").concat(timeMs, "ms");
      logState.attributeUpdateMessages.push(message);
    },
    'deckRenderer.renderLayers': function deckRendererRenderLayers(deckRenderer, renderStats, opts) {
      var pass = opts.pass,
          redrawReason = opts.redrawReason,
          stats = opts.stats;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = renderStats[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var status = _step2.value;
          var totalCount = status.totalCount,
              visibleCount = status.visibleCount,
              compositeCount = status.compositeCount,
              pickableCount = status.pickableCount;
          var primitiveCount = totalCount - compositeCount;
          var hiddenCount = primitiveCount - visibleCount;
          log.log(LOG_LEVEL_DRAW, "RENDER #".concat(deckRenderer.renderCount, "   ").concat(visibleCount, " (of ").concat(totalCount, " layers) to ").concat(pass, " because ").concat(redrawReason, "   (").concat(hiddenCount, " hidden, ").concat(compositeCount, " composite ").concat(pickableCount, " pickable)"))();

          if (stats) {
            stats.get('Redraw Layers').add(visibleCount);
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  };
};
//# sourceMappingURL=loggers.js.map