import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import debug from '../debug';
import DrawLayersPass from '../passes/draw-layers-pass';
import PickLayersPass from '../passes/pick-layers-pass';
import { Framebuffer } from '@luma.gl/core';
var TRACE_RENDER_LAYERS = 'deckRenderer.renderLayers';

var DeckRenderer = function () {
  function DeckRenderer(gl) {
    _classCallCheck(this, DeckRenderer);

    this.gl = gl;
    this.layerFilter = null;
    this.drawPickingColors = false;
    this.drawLayersPass = new DrawLayersPass(gl);
    this.pickLayersPass = new PickLayersPass(gl);
    this.renderCount = 0;
    this._needsRedraw = 'Initial render';
    this.renderBuffers = [];
    this.lastPostProcessEffect = null;
    this._onError = null;
  }

  _createClass(DeckRenderer, [{
    key: "setProps",
    value: function setProps(props) {
      if ('layerFilter' in props && this.layerFilter !== props.layerFilter) {
        this.layerFilter = props.layerFilter;
        this._needsRedraw = 'layerFilter changed';
      }

      if ('drawPickingColors' in props && this.drawPickingColors !== props.drawPickingColors) {
        this.drawPickingColors = props.drawPickingColors;
        this._needsRedraw = 'drawPickingColors changed';
      }

      if ('onError' in props) {
        this._onError = props.onError;
      }
    }
  }, {
    key: "renderLayers",
    value: function renderLayers(opts) {
      var layerPass = this.drawPickingColors ? this.pickLayersPass : this.drawLayersPass;
      opts.layerFilter = this.layerFilter;
      opts.onError = this._onError;
      opts.effects = opts.effects || [];
      opts.target = opts.target || Framebuffer.getDefaultFramebuffer(this.gl);

      this._preRender(opts.effects, opts);

      var outputBuffer = this.lastPostProcessEffect ? this.renderBuffers[0] : opts.target;
      var renderStats = layerPass.render(_objectSpread({}, opts, {
        target: outputBuffer
      }));

      this._postRender(opts.effects, opts);

      this.renderCount++;
      debug(TRACE_RENDER_LAYERS, this, renderStats, opts);
    }
  }, {
    key: "needsRedraw",
    value: function needsRedraw() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        clearRedrawFlags: false
      };
      var redraw = this._needsRedraw;

      if (opts.clearRedrawFlags) {
        this._needsRedraw = false;
      }

      return redraw;
    }
  }, {
    key: "finalize",
    value: function finalize() {
      var renderBuffers = this.renderBuffers;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = renderBuffers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var buffer = _step.value;
          buffer["delete"]();
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      renderBuffers.length = 0;
    }
  }, {
    key: "_preRender",
    value: function _preRender(effects, opts) {
      var lastPostProcessEffect = null;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = effects[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var effect = _step2.value;
          effect.preRender(this.gl, opts);

          if (effect.postRender) {
            lastPostProcessEffect = effect;
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      if (lastPostProcessEffect) {
        this._resizeRenderBuffers();
      }

      this.lastPostProcessEffect = lastPostProcessEffect;
    }
  }, {
    key: "_resizeRenderBuffers",
    value: function _resizeRenderBuffers() {
      var renderBuffers = this.renderBuffers;

      if (renderBuffers.length === 0) {
        renderBuffers.push(new Framebuffer(this.gl), new Framebuffer(this.gl));
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = renderBuffers[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var buffer = _step3.value;
          buffer.resize();
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
            _iterator3["return"]();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: "_postRender",
    value: function _postRender(effects, opts) {
      var renderBuffers = this.renderBuffers;
      var params = {
        inputBuffer: renderBuffers[0],
        swapBuffer: renderBuffers[1],
        target: null
      };
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = effects[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var effect = _step4.value;

          if (effect.postRender) {
            if (effect === this.lastPostProcessEffect) {
              params.target = opts.target;
              effect.postRender(this.gl, params);
              break;
            }

            var buffer = effect.postRender(this.gl, params);
            params.inputBuffer = buffer;
            params.swapBuffer = buffer === renderBuffers[0] ? renderBuffers[1] : renderBuffers[0];
          }
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4["return"] != null) {
            _iterator4["return"]();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return DeckRenderer;
}();

export { DeckRenderer as default };
//# sourceMappingURL=deck-renderer.js.map